import { BizError } from "../../util/bizError";
import { getInterfaceByInterfaceName } from "./cronJob";

export async function getSqjjhl() {
    let interfaceName = "商圈经济活力";
    let {basicData, CIIEHolidayVitalityIndex, zhaoXiangDistrictHolidayVitalityIndex, qingPuNewTownHolidayVitalityIndex, zhuJiaJiaoHolidayVitalityIndex,
        qingPuKeyBusinessDistrictIndex, CIIEConsumptionTypeAnalysis, zhaoXiangConsumptionTypeAnalysis, zhuJiaJiaoConsumptionTypeAnalysis, 
        qingPuNewTownConsumptionTypeAnalysis, qingPuEconomicVitalityTrend, rangeData} = await getInterfaceByInterfaceName(interfaceName);
    
    // ----------------test-------------------
    // let basicData = {overallEconomicVitalityIndex:""};
    // let CIIEHolidayVitalityIndex = [{"holidayName":"春节","eat":0.0000,"live":186.4200,"game":104.6200,"entertainment":0.0000,"shopping":102.4300}];
    // let zhaoXiangDistrictHolidayVitalityIndex = [{"holidayName":"春节","eat":0.0000,"live":0.0000,"game":99.0600,"entertainment":0.0000,"shopping":180.5600}];
    // let qingPuNewTownHolidayVitalityIndex = [{"holidayName":"春节","eat":107.0100,"live":117.4700,"game":109.8000,"entertainment":127.9600,"shopping":100.3200}];
    // let zhuJiaJiaoHolidayVitalityIndex = [{"holidayName":"春节","eat":182.1800,"live":103.8200,"game":90.8900,"entertainment":110.1000,"shopping":177.8700}];
    // let qingPuKeyBusinessDistrictIndex = [];
    // let CIIEConsumptionTypeAnalysis = [{"month":"202109","eat":0.0000,"live":97.1500,"game":81.4600,"entertainment":77.4200,"shopping":99.4700},{"month":"202110","eat":0.0000,"live":113.9700,"game":84.0200,"entertainment":108.4100,"shopping":100.4100},{"month":"202111","eat":0.0000,"live":95.9700,"game":96.1000,"entertainment":118.2700,"shopping":74.1400},{"month":"202112","eat":0.0000,"live":117.9500,"game":85.7900,"entertainment":119.3000,"shopping":114.3800},{"month":"202201","eat":0.0000,"live":131.7000,"game":78.7600,"entertainment":90.0000,"shopping":88.1600},{"month":"202202","eat":0.0000,"live":132.5400,"game":87.1900,"entertainment":126.8000,"shopping":82.3000},{"month":"202203","eat":0.0000,"live":151.5800,"game":93.8200,"entertainment":71.3300,"shopping":124.7600},{"month":"202204","eat":0.0000,"live":18.5500,"game":69.8300,"entertainment":18.5500,"shopping":31.5800},{"month":"202205","eat":0.0000,"live":112.5900,"game":76.5900,"entertainment":20.7800,"shopping":40.8400},{"month":"202206","eat":0.0000,"live":103.4612,"game":44.4928,"entertainment":0.0000,"shopping":88.2199}];
    // let zhaoXiangConsumptionTypeAnalysis = [{"month":"202109","eat":0.0000,"live":12.5000,"game":97.3500,"entertainment":0.0000,"shopping":67.8300},{"month":"202110","eat":0.0000,"live":100.0000,"game":98.0900,"entertainment":0.0000,"shopping":76.9700},{"month":"202111","eat":0.0000,"live":1.1100,"game":99.5600,"entertainment":0.0000,"shopping":50.5000},{"month":"202112","eat":0.0000,"live":1.3800,"game":76.8500,"entertainment":0.0000,"shopping":125.9400},{"month":"202201","eat":0.0000,"live":87.5000,"game":68.9100,"entertainment":0.0000,"shopping":94.2500},{"month":"202202","eat":0.0000,"live":5.1700,"game":92.1000,"entertainment":0.0000,"shopping":94.3000},{"month":"202203","eat":0.0000,"live":100.0000,"game":89.8300,"entertainment":0.0000,"shopping":80.4600},{"month":"202204","eat":0.0000,"live":87.5000,"game":82.8700,"entertainment":0.0000,"shopping":10.9500},{"month":"202205","eat":0.0000,"live":100.0000,"game":77.7900,"entertainment":0.0000,"shopping":40.2400},{"month":"202206","eat":0.0000,"live":716.6667,"game":124.0882,"entertainment":0.0000,"shopping":71.6589}];
    // let zhuJiaJiaoConsumptionTypeAnalysis = [{"month":"202109","eat":76.9500,"live":101.5500,"game":73.1600,"entertainment":0.0000,"shopping":87.4700},{"month":"202110","eat":95.6700,"live":112.2600,"game":95.3000,"entertainment":0.0000,"shopping":81.2500},{"month":"202111","eat":82.0000,"live":101.6600,"game":117.6100,"entertainment":0.0000,"shopping":79.4000},{"month":"202112","eat":101.2600,"live":105.6900,"game":119.7200,"entertainment":0.0000,"shopping":97.4800},{"month":"202201","eat":88.8500,"live":86.3100,"game":90.2000,"entertainment":0.0000,"shopping":87.6500},{"month":"202202","eat":86.6200,"live":98.9200,"game":92.5800,"entertainment":0.0000,"shopping":95.1300},{"month":"202203","eat":47.8300,"live":83.0100,"game":63.5100,"entertainment":0.0000,"shopping":59.0500},{"month":"202204","eat":20.9300,"live":45.8100,"game":33.6700,"entertainment":0.0000,"shopping":26.6200},{"month":"202205","eat":29.4300,"live":73.9400,"game":59.2700,"entertainment":0.0000,"shopping":18.7100},{"month":"202206","eat":38.1160,"live":96.7222,"game":64.3525,"entertainment":82.2432,"shopping":53.0803}];
    // let qingPuNewTownConsumptionTypeAnalysis = [{"month":"202109","eat":103.6200,"live":70.0600,"game":93.9500,"entertainment":95.3100,"shopping":94.7700},{"month":"202110","eat":115.3200,"live":103.2600,"game":95.2300,"entertainment":101.3100,"shopping":103.3900},{"month":"202111","eat":90.3300,"live":91.2900,"game":80.1400,"entertainment":105.6700,"shopping":98.9400},{"month":"202112","eat":111.9600,"live":110.6000,"game":95.4200,"entertainment":102.4500,"shopping":114.2900},{"month":"202201","eat":110.7000,"live":101.2100,"game":88.3200,"entertainment":108.0600,"shopping":93.2900},{"month":"202202","eat":91.6600,"live":109.8600,"game":85.3200,"entertainment":92.8300,"shopping":75.1600},{"month":"202203","eat":110.2900,"live":108.6000,"game":106.3600,"entertainment":106.9000,"shopping":110.3100},{"month":"202204","eat":28.0100,"live":39.2900,"game":77.9800,"entertainment":82.8900,"shopping":30.6200},{"month":"202205","eat":52.1500,"live":76.0500,"game":80.6100,"entertainment":92.2400,"shopping":43.9900},{"month":"202206","eat":80.4087,"live":60.1710,"game":87.2616,"entertainment":77.6029,"shopping":91.0826}];
    // let qingPuEconomicVitalityTrend = [{"month":"202111","qingPuNewTown":973.5985,"CIIECoreArea":889.1356,"zhaoXiangCommercialBusiness":725.8034,"zhuJiaJiaoAncientTown":775.9753}];
    // let rangeData = {regionalScope:"", timeRange:""};
    // ---------------end------------------------

    if (JSON.stringify(basicData) === '{}') basicData = {overallEconomicVitalityIndex:"0"};
    if (JSON.stringify(rangeData) === '{}') rangeData = {regionalScope:"", timeRange:""};

    if (!basicData) throw new BizError(`${interfaceName} 缺少参数 basicData` );
    if (!CIIEHolidayVitalityIndex) throw new BizError(`${interfaceName} 缺少参数 CIIEHolidayVitalityIndex` );
    if (!zhaoXiangDistrictHolidayVitalityIndex) throw new BizError(`${interfaceName} 缺少参数 zhaoXiangDistrictHolidayVitalityIndex` );
    if (!qingPuNewTownHolidayVitalityIndex) throw new BizError(`${interfaceName} 缺少参数 qingPuNewTownHolidayVitalityIndex` );
    if (!zhuJiaJiaoHolidayVitalityIndex) throw new BizError(`${interfaceName} 缺少参数 zhuJiaJiaoHolidayVitalityIndex` );
    if (!qingPuKeyBusinessDistrictIndex) throw new BizError(`${interfaceName} 缺少参数 qingPuKeyBusinessDistrictIndex` );
    if (!CIIEConsumptionTypeAnalysis) throw new BizError(`${interfaceName} 缺少参数 CIIEConsumptionTypeAnalysis` );
    if (!zhaoXiangConsumptionTypeAnalysis) throw new BizError(`${interfaceName} 缺少参数 zhaoXiangConsumptionTypeAnalysis` );
    if (!zhuJiaJiaoConsumptionTypeAnalysis) throw new BizError(`${interfaceName} 缺少参数 zhuJiaJiaoConsumptionTypeAnalysis` );
    if (!qingPuNewTownConsumptionTypeAnalysis) throw new BizError(`${interfaceName} 缺少参数 qingPuNewTownConsumptionTypeAnalysis` );
    if (!qingPuEconomicVitalityTrend) throw new BizError(`${interfaceName} 缺少参数 qingPuEconomicVitalityTrend` );
    if (!rangeData) throw new BizError(`${interfaceName} 缺少参数 rangeData` );

    let {overallEconomicVitalityIndex} = basicData;
    let basicInfo = {总体经济活力指数: overallEconomicVitalityIndex};

    //进博会核心区节假日活力指数分析
    let CIIEHoliday = getHolidayVitalityIndex(CIIEHolidayVitalityIndex);

    //赵巷区节假日活力指数分析
    let zhaoXiangDistrictHoliday= getHolidayVitalityIndex(zhaoXiangDistrictHolidayVitalityIndex);

    //青浦新城节假日活力指数分析
    let qingPuNewTownHoliday = getHolidayVitalityIndex(qingPuNewTownHolidayVitalityIndex);

    //朱家角古镇节假日活力指数分析
    let zhuJiaJiaoHoliday = getHolidayVitalityIndex(zhuJiaJiaoHolidayVitalityIndex);

    //青浦重点商圈经济活力指数
    let qingPuKeyBusiness= getKeyBusinessDistrictIndex(qingPuKeyBusinessDistrictIndex);

    //进博会核心区消费类型分析
    let CIIEConsumption = getMonthData(CIIEConsumptionTypeAnalysis);

    //赵巷区消费类型分析
    let zhaoXiangConsumption = getMonthData(zhaoXiangConsumptionTypeAnalysis);

    //朱家角古镇区消费类型分析
    let zhuJiaJiaoConsumption = getMonthData(zhuJiaJiaoConsumptionTypeAnalysis);

    //青浦新城消费类型分析
    let qingPuNewTownConsumption = getMonthData(qingPuNewTownConsumptionTypeAnalysis);

    //青浦重点商圈经济活力变化趋势
    let qingPuEconomicVitalityTrendData;
    let qingPuNewTownData = {};
    let CIIECoreAreaData = {};
    let zhaoXiangCommercialBusinessData = {};
    let zhuJiaJiaoAncientTownData = {};
    qingPuEconomicVitalityTrend.forEach( info => {
        let {month, qingPuNewTown, CIIECoreArea, zhaoXiangCommercialBusiness, zhuJiaJiaoAncientTown} = info;
        qingPuNewTownData[month] = qingPuNewTown;
        CIIECoreAreaData[month] = CIIECoreArea;
        zhuJiaJiaoAncientTownData[month] = zhuJiaJiaoAncientTown;
        zhaoXiangCommercialBusinessData[month] = zhaoXiangCommercialBusiness;
    })
    qingPuEconomicVitalityTrendData = {青浦新城: qingPuNewTownData, 赵巷商业商务: CIIECoreAreaData, 朱家角古镇: zhaoXiangCommercialBusinessData, 进博会核心区: zhuJiaJiaoAncientTownData};

    //范围数据
    let {regionalScope, timeRange} = rangeData;
    let rangeInfo = {
        "区域范围": regionalScope,
        "时间范围": timeRange
    };

    return {basicInfo, CIIEHoliday, zhaoXiangDistrictHoliday, qingPuNewTownHoliday, zhuJiaJiaoHoliday, 
        qingPuKeyBusiness, CIIEConsumption, zhaoXiangConsumption, zhuJiaJiaoConsumption, qingPuNewTownConsumption, qingPuEconomicVitalityTrendData, rangeInfo};
}

//获取节假日活力指数分析
function getHolidayVitalityIndex(dataList) {
    let dataInfo;
    let eatData = {};
    let liveData = {};
    let gameData = {};
    let entertainmentData = {};
    let shoppingData = {};
    dataList.forEach( info => {
        let {holidayName, eat, live, game, entertainment, shopping} = info;
        eatData[holidayName] = eat;
        liveData[holidayName] = live;
        gameData[holidayName] = game;
        entertainmentData[holidayName] = entertainment;
        shoppingData[holidayName] = shopping;
    })
    dataInfo = {吃: eatData, 住: liveData, 游: gameData, 娱: entertainmentData, 购: shoppingData};

    return dataInfo;
}

//获取商圈经济活力指数
function getKeyBusinessDistrictIndex(dataList) {
    let dataInfo;
    let currYearData = {}; //当年
    let lastYearData = {}; //去年
    let yoyGrowthData = {}; //同比
    dataList.forEach( info => {
        let {businessName, currYear, lastYear, yoyGrowth} = info;
        currYearData[info.businessName] = currYear;
        lastYearData[businessName] = lastYear;
        yoyGrowthData[businessName] = yoyGrowth;
    })
    dataInfo = {'2021年': lastYearData, '2022年': currYearData, '2022年同比增长': yoyGrowthData};

    return dataInfo;
}

function getMonthData(dataList) {
    let dataInfo;
    let eatData = {};
    let liveData = {};
    let gameData = {};
    let entertainmentData = {};
    let shoppingData = {};
    dataList.forEach( info => {
        let {month, eat, live, game, entertainment, shopping} = info;
        eatData[month] = eat;
        liveData[month] = live;
        gameData[month] = game;
        entertainmentData[month] = entertainment;
        shoppingData[month] = shopping;
    })
    dataInfo = {吃: eatData, 住: liveData, 游: gameData, 娱: entertainmentData, 购: shoppingData};

    return dataInfo;
}