import { BizError } from "../../util/bizError";
import { getInterfaceByInterfaceName } from "./cronJob";

export async function getSfqztgk() {
    let interfaceName = "示范区总体概况";
    let {rangeData} = await getInterfaceByInterfaceName(interfaceName);
    // let rangeData = {"regionalScope":"青浦区", "timeRange": "2021年1月-2022年1月"}

    if (JSON.stringify(rangeData) === '{}') rangeData = {regionalScope:"", timeRange:""};
    
    if (!rangeData) throw new BizError(`${interfaceName} 缺少参数 rangeData` );

    //范围数据
    let {regionalScope, timeRange} = rangeData;
    let rangeInfo = {
        "区域范围": regionalScope,
        "时间范围": timeRange
    };

    return {rangeInfo};
}