import { BizError } from "../../util/bizError";
import { getInterfaceByInterfaceName } from "./cronJob";

export async function getQyrh() {
    let interfaceName = "区域融合";
    let {dutyManagement, realTimeMonitoring, monitoringResults, businessDefecation, businessTimeliness, businessInteractivity, schedulingLogOverhaulSchedule, 
        schedulingLogTroubleshooting, schedulingLogPowerOutage, schedulingLogDeviceDefect, schedulingLogAccidentException} = await getInterfaceByInterfaceName(interfaceName);

    // ------------------------test--------------------------
    // let dutyManagement = [
    //     {
    //         "name":"青浦-周佳佳",
    //         "required":"是"
    //     },
    //     {
    //         "name":"青浦-赵璐璐",
    //         "required":"否"
    //     }
    // ];
    // let realTimeMonitoring = {
    //     "redCode":"1797",
    //     "blackCode":"5990",
    //     "blueCode":"0",
    //     "redBlueCode":"0"
    // };
    // let monitoringResults = {
    //     "uneconomicalElectricity":"276",
    //     "electricalTestAre":"688",
    //     "excessCapacity":"1367",
    //     "reactiveCompensation":"1307"
    // };
    // let businessDefecation = {
    //     "businessLineApplication":"1757",
    //     "onlinePayment":"42.09",
    //     "doElectricityCut":"2",
    //     "reductionOfApplicationMaterials":"3"
    // };
    // let businessTimeliness = {
    //     "highElectricityAverageLength":"63.15",
    //     "LowElectricityAverageLength":"2.79"
    // };
    // let businessInteractivity = {
    //     "value":"无",
    //     "ItsChineseOnline":"无",
    //     "FreeNetPhoneDo":"无",
    //     "BusinessHall":"无"
    // };
    // let schedulingLogOverhaulSchedule = [
    //     {
    //         "serialNumber":"01",
    //         "area":"青浦",
    //         "jobContent":"35千伏干俞8199线路迁改工程......",
    //         "dateTime":"2021/9/24"
    //     },
    //     {
    //     "serialNumber":"02",
    //     "area":"青浦",
    //     "jobContent":"练5泗联03843四农12队配变220v低压电压过低......",
    //     "dateTime":"2021/9/18"
    //     }
    // ];
    // let schedulingLogTroubleshooting = [
    //     {
    //         "serialNumber":"01",
    //         "area":"嘉善",
    //         "jobContent":"【客户内部故障】下发为低压故障......",
    //         "dateTime":"2021/8/29"
    //         },
    //         {
    //         "serialNumber":"02",
    //         "area":"嘉善",
    //         "jobContent":"【客户内部故障】下发为低压故障......",
    //         "dateTime":"2021/8/25"
    //         }
    // ];
    // let schedulingLogPowerOutage = [
    //     {
    //         "serialNumber":"01",
    //         "area":"青浦",
    //         "jobContent":"35千伏干俞8199线路迁改工程......",
    //         "dateTime":"2021/8/29"
    //         },
    //         {
    //         "serialNumber":"02",
    //         "area":"青浦",
    //         "jobContent":"练5泗联03843四农12队配变220v低压电压过低......",
    //         "dateTime":"2021/8/25"
    //         }
    // ];
    // let schedulingLogDeviceDefect = [
    //     {
    //         "serialNumber":"01",
    //         "area":"嘉善",
    //         "jobContent":"保测装置通信中断......",
    //         "dateTime":"2020/10/19"
    //         },
    //         {
    //         "serialNumber":"02",
    //         "area":"嘉善",
    //         "jobContent":"练5泗联18-6#位于村水泥路中间......",
    //         "dateTime":"2020/8/1"
    //         }
    // ];
    // let schedulingLogAccidentException = [
    //     {
    //         "serialNumber":"01",
    //         "area":"嘉善",
    //         "jobContent":"嘉善地区 110kV云寺变......",
    //         "dateTime":"2021/9/20"
    //         },
    //         {
    //         "serialNumber":"02",
    //         "area":"嘉善",
    //         "jobContent":"嘉善地区 110kV陶庄变......",
    //         "dateTime":"2021/9/16"
    //         }
    // ];
    // ------------------------end--------------------------
    
    if (JSON.stringify(realTimeMonitoring) === '{}') realTimeMonitoring = {redCode:"0", blackCode:"0", blueCode:"0", redBlueCode:"0"};
    if (JSON.stringify(monitoringResults) === '{}') monitoringResults = {uneconomicalElectricity:"0", electricalTestAre:"0", excessCapacity:"0", reactiveCompensation:"0"};
    if (JSON.stringify(businessDefecation) === '{}') businessDefecation = {businessLineApplication:"0", onlinePayment:"0", doElectricityCut:"0", reductionOfApplicationMaterials:"0"};
    if (JSON.stringify(businessTimeliness) === '{}') businessTimeliness = {highElectricityAverageLength:"0", LowElectricityAverageLength:"0"};
    if (JSON.stringify(businessInteractivity) === '{}') businessInteractivity = {value:"0", ItsChineseOnline:"0", FreeNetPhoneDo:"0", BusinessHall:"0"};

    if (!dutyManagement) throw new BizError(`${interfaceName} 缺少参数 dutyManagement` );
    if (!realTimeMonitoring) throw new BizError(`${interfaceName} 缺少参数 realTimeMonitoring` );
    if (!monitoringResults) throw new BizError(`${interfaceName} 缺少参数 monitoringResults` );
    if (!businessDefecation) throw new BizError(`${interfaceName} 缺少参数 businessDefecation` );
    if (!businessTimeliness) throw new BizError(`${interfaceName} 缺少参数 businessTimeliness` );
    if (!businessInteractivity) throw new BizError(`${interfaceName} 缺少参数 businessInteractivity` );
    if (!schedulingLogOverhaulSchedule) throw new BizError(`${interfaceName} 缺少参数 schedulingLogOverhaulSchedule` );
    if (!schedulingLogTroubleshooting) throw new BizError(`${interfaceName} 缺少参数 schedulingLogTroubleshooting` );
    if (!schedulingLogPowerOutage) throw new BizError(`${interfaceName} 缺少参数schedulingLogPowerOutage` );
    if (!schedulingLogDeviceDefect) throw new BizError(`${interfaceName} 缺少参数 schedulingLogDeviceDefect` );
    if (!schedulingLogAccidentException) throw new BizError(`${interfaceName} 缺少参数 schedulingLogAccidentException` );

    let {redCode, blackCode, blueCode, redBlueCode} = realTimeMonitoring;
    //码上办实时监测
    let realTimeMonitoringInfo = {红码: redCode + "个", 黑码: blackCode + "个", 蓝码: blueCode + "个", 红蓝码: redBlueCode + "个"};

    //码上办监测结果
    let {uneconomicalElectricity, electricalTestAre, excessCapacity, reactiveCompensation} = monitoringResults;
    let monitoringResultsInfo = {电费不经济: uneconomicalElectricity, 电试超期: electricalTestAre, 超容: excessCapacity, 无功补偿: reactiveCompensation};

    //营商业务便利性-青浦区
    let {businessLineApplication, onlinePayment, doElectricityCut, reductionOfApplicationMaterials} = businessDefecation;
    let easeOfDoingInfo = {
        业务线上申请: businessLineApplication + "次", 
        线上缴费: onlinePayment + "万次", 
        办点环节缩减至: doElectricityCut + "个", 
        申请材料缩减至: reductionOfApplicationMaterials + "项"
    };

    //营商业务及时性-青浦区
    let {highElectricityAverageLength, LowElectricityAverageLength} = businessTimeliness;
    let timelinessInfo = {
        高压办电平均时长: highElectricityAverageLength + "天",
        低压办电平均时长: LowElectricityAverageLength + "天"
    };

    //营商业务互动性-青浦区
    let {value, ItsChineseOnline, FreeNetPhoneDo, BusinessHall} = businessInteractivity;
    let interactivityInfo = {
        95598: value,
        网上国网: ItsChineseOnline, 
        一网通办: FreeNetPhoneDo, 
        营业厅: BusinessHall 
    };

    //调度日志-检修计划
    let titleList = ["序号", "区域", "工作内容", "日期"];
    let overhaulSchedule = {titleList, dataList:schedulingLogOverhaulSchedule};

    //调度日志-故障抢修
    let troubleshooting = {titleList, dataList:schedulingLogTroubleshooting};

    //调度日志-停电停役
    let powerOutage = {titleList, dataList:schedulingLogPowerOutage};

    //调度日志-设备缺陷
    let deviceDefect = {titleList, dataList: schedulingLogDeviceDefect};

    //调度日志-事故异常
    let accidentException = {titleList, dataList:schedulingLogAccidentException};

    return {dutyManagement, realTimeMonitoringInfo, monitoringResultsInfo, easeOfDoingInfo, timelinessInfo, interactivityInfo, 
        schedulingLogOverhaulSchedule, schedulingLogTroubleshooting, schedulingLogPowerOutage, schedulingLogDeviceDefect, schedulingLogAccidentException};
}