import { BizError } from "../../util/bizError";
import { getInterfaceByInterfaceName } from "./cronJob";

export async function getQydzxypg() {
    let interfaceName = "企业贷中信用评估";
    let {distributionOfEachCreditRating, highQualityCreditEnterprise, ventureEnterprise, monthlyBusinessCreditChanges, industryCreditDistribution, rangeData} = await getInterfaceByInterfaceName(interfaceName);
    
    // -----------------test-----------------
    // let distributionOfEachCreditRating:any = {"excellentCredit":0.0000,"goodCredit":0.0000,"generalCredit":0.0000,"poorCredit":0.0000};
    // let highQualityCreditEnterprise = [{"companyName":"上海幼儿园","value":100}];
    // let ventureEnterprise = [{"companyName":"深圳市花样年国际物业服务有限公司上海分公司","value":65.000},{"companyName":"融信世欧物业服务集团有限公司上海分公司","value":65.000},{"companyName":"地下1层防火分区二车库排烟风机(常备用)","value":65.000},{"companyName":"上海伯爵厨房设备有限公司","value":63.330},{"companyName":"上海甫多电气有限公司","value":54.390}];
    // let monthlyBusinessCreditChanges = [{"month":"202109","excellentCredit":2535.0000,"goodCredit":876.0000,"generalCredit":607.0000,"poorCredit":405.0000},{"month":"202110","excellentCredit":2684.0000,"goodCredit":767.0000,"generalCredit":569.0000,"poorCredit":393.0000},{"month":"202111","excellentCredit":2342.0000,"goodCredit":894.0000,"generalCredit":695.0000,"poorCredit":475.0000},{"month":"202112","excellentCredit":2474.0000,"goodCredit":868.0000,"generalCredit":602.0000,"poorCredit":483.0000},{"month":"202201","excellentCredit":2203.0000,"goodCredit":1064.0000,"generalCredit":637.0000,"poorCredit":550.0000},{"month":"202202","excellentCredit":2096.0000,"goodCredit":1001.0000,"generalCredit":624.0000,"poorCredit":699.0000},{"month":"202203","excellentCredit":2014.0000,"goodCredit":1129.0000,"generalCredit":638.0000,"poorCredit":714.0000},{"month":"202204","excellentCredit":2026.0000,"goodCredit":1150.0000,"generalCredit":678.0000,"poorCredit":657.0000},{"month":"202205","excellentCredit":1595.0000,"goodCredit":1279.0000,"generalCredit":851.0000,"poorCredit":788.0000},{"month":"202206","excellentCredit":1459.0000,"goodCredit":1313.0000,"generalCredit":984.0000,"poorCredit":757.0000}];
    // let rangeData = {"regionalScope":"青浦区","timeRange":"2022年7月"};
    // ------------------end-----------------

    if (JSON.stringify(distributionOfEachCreditRating) === '{}') distributionOfEachCreditRating = {excellentCredit:0, goodCredit:0, generalCredit:0, poorCredit:0};
    if (JSON.stringify(rangeData) === '{}') rangeData = {regionalScope:"", timeRange:""};

    if (!distributionOfEachCreditRating) throw new BizError(`${interfaceName} 缺少参数 distributionOfEachCreditRating` );
    if (!highQualityCreditEnterprise) throw new BizError(`${interfaceName} 缺少参数 highQualityCreditEnterprise` );
    if (!ventureEnterprise) throw new BizError(`${interfaceName} 缺少参数 ventureEnterprise` );
    if (!monthlyBusinessCreditChanges) throw new BizError(`${interfaceName} 缺少参数 monthlyBusinessCreditChanges` );
    if (!rangeData) throw new BizError(`${interfaceName} 缺少参数 rangeData` );

    //各信用等级企业分布情况
    let {excellentCredit, goodCredit, generalCredit, poorCredit} = distributionOfEachCreditRating;
    let distributionInfo = {
        信用极好: excellentCredit + "户",
        信用良好: goodCredit + "户",
        信用一般: generalCredit + "户",
        信用差: poorCredit + "户"
    };

    //优质信用企业
    let highQuality = {};
    highQualityCreditEnterprise.sort(function(a, b) {
        return a.value - b.value;
    });
    highQualityCreditEnterprise.forEach( info => {
        let {companyName, value} = info;
        highQuality[companyName] = value;
    })

    //风险企业
    let venture = {};
    ventureEnterprise.sort(function(a, b) {
        return a.value - b.value;
    });
    ventureEnterprise.forEach( info => {
        let {companyName, value} = info;
        // companyName = companyName.slice(0, 5);
        venture[companyName] = value;
    })

    //每月企业信用变化趋势
    let monthlyBusinessInfo;
    let excellentCreditData = {};
    let goodCreditData = {};
    let generalCreditData = {};
    let poorCreditData = {};
    monthlyBusinessCreditChanges.forEach( info => {
        let {month, excellentCredit, goodCredit, generalCredit, poorCredit} = info;
        // let monthly = month.slice(month.length - 2, month.length) + "月";
        let monthly = month;
        excellentCreditData[monthly] = excellentCredit;
        goodCreditData[monthly] = goodCredit;
        generalCreditData[monthly] = generalCredit;
        poorCreditData[monthly] = poorCredit;
    })
    monthlyBusinessInfo = {信用极好: excellentCreditData, 信用良好: goodCreditData, 信用一般: generalCreditData, 信用差: poorCreditData}

    //范围数据
    let {regionalScope, timeRange} = rangeData;
    let rangeInfo = {
        "区域范围": regionalScope,
        "时间范围": timeRange
    };

    return {distributionInfo, highQuality, venture, monthlyBusinessInfo, rangeInfo};
}

export async function getindustryCredit() {
    let interfaceName = "企业贷中信用评估";
    let {industryCreditDistribution} = await getInterfaceByInterfaceName(interfaceName);
    // let industryCreditDistribution = [{"industryName":"农,林,牧,渔业","excellentCredit":0.0000,"goodCredit":0.0000,"generalCredit":0.0000,"poorCredit":0.0000},{"industryName":"工业","excellentCredit":0.0000,"goodCredit":0.0000,"generalCredit":0.0000,"poorCredit":0.0000},{"industryName":"建筑业","excellentCredit":0.0000,"goodCredit":0.0000,"generalCredit":0.0000,"poorCredit":0.0000},{"industryName":"交通运输，仓储和邮政业","excellentCredit":0.0000,"goodCredit":0.0000,"generalCredit":0.0000,"poorCredit":0.0000},{"industryName":"信息传输,软件和信息技术服务业","excellentCredit":0.0000,"goodCredit":0.0000,"generalCredit":0.0000,"poorCredit":0.0000},{"industryName":"批发和零售业","excellentCredit":0.0000,"goodCredit":0.0000,"generalCredit":0.0000,"poorCredit":0.0000},{"industryName":"住宿和餐饮业","excellentCredit":0.0000,"goodCredit":0.0000,"generalCredit":0.0000,"poorCredit":0.0000},{"industryName":"金融业","excellentCredit":0.0000,"goodCredit":0.0000,"generalCredit":0.0000,"poorCredit":0.0000},{"industryName":"房地产业","excellentCredit":0.0000,"goodCredit":0.0000,"generalCredit":0.0000,"poorCredit":0.0000},{"industryName":"租赁和商务服务业","excellentCredit":0.0000,"goodCredit":0.0000,"generalCredit":0.0000,"poorCredit":0.0000},{"industryName":"公共服务及管理组织","excellentCredit":0.0000,"goodCredit":0.0000,"generalCredit":0.0000,"poorCredit":0.0000}];

    if (!industryCreditDistribution) throw new BizError(`${interfaceName} 缺少参数 industryCreditDistribution` );

    //行业信用分布对比
    let industryCreditInfo;
    let excellentCreditData = {};
    let goodCreditData = {};
    let generalCreditData = {};
    let poorCreditData = {};
    industryCreditDistribution.forEach( info => {
        let {industryName, excellentCredit, goodCredit, generalCredit, poorCredit} = info;
        excellentCreditData[industryName] = excellentCredit;
        goodCreditData[industryName] = goodCredit;
        generalCreditData[industryName] = generalCredit;
        poorCreditData[industryName] = poorCredit;
    })
    industryCreditInfo = {信用极好: excellentCreditData, 信用良好: goodCreditData, 信用一般: generalCreditData, 信用差: poorCreditData}

    return {industryCreditInfo};
}
