import { BizError } from "../../util/bizError";
import { getInterfaceByInterfaceName } from "./cronJob";

export async function getQjnygfjr() {
    let interfaceName = "绿色电力清洁能源光伏接入";
    let {totalCustomer, realTimeMonitoring, distributedPvCustomerTrends, distributedPhotovoltaicCustomer, powerAnalysis} = await getInterfaceByInterfaceName(interfaceName);
    
    // -----------------test---------------
    // let totalCustomer:any = {"nonResidentCustomer":144,"residentCustomer":2156};
    // let realTimeMonitoring:any = {"NO2":136.0100,"SO2":272.0100,"CO2":9039.8100};
    // let distributedPvCustomerTrends = [{"year":"2013","value":52},{"year":"2014","value":38},{"year":"2015","value":103},{"year":"2016","value":230},{"year":"2017","value":647},{"year":"2018","value":551},{"year":"2019","value":208},{"year":"2020","value":216},{"year":"2021","value":222}];
    // let distributedPhotovoltaicCustomer:any = {"distributedPvCustomer":2300,"proportionOfNonResidents":6.26};
    // let powerAnalysis = [{"month":"202109","powerGeneration":678.26,"theInternetCharge":283.06},{"month":"202110","powerGeneration":545.48,"theInternetCharge":261.63},{"month":"202111","powerGeneration":817.33,"theInternetCharge":391.54},{"month":"202112","powerGeneration":565.76,"theInternetCharge":221.11},{"month":"202201","powerGeneration":499.96,"theInternetCharge":171.82},{"month":"202202","powerGeneration":586.67,"theInternetCharge":241.58},{"month":"202203","powerGeneration":676.75,"theInternetCharge":306.13},{"month":"202204","powerGeneration":767.72,"theInternetCharge":520.13},{"month":"202205","powerGeneration":806.03,"theInternetCharge":451.83},{"month":"202206","powerGeneration":906.70,"theInternetCharge":331.05}];
    // ----------------end------------------

    if (JSON.stringify(totalCustomer) === '{}') totalCustomer = {residentCustomer:0, nonResidentCustomer:0};
    if (JSON.stringify(realTimeMonitoring) === '{}') realTimeMonitoring = {NO2:0, SO2:0, CO2:0};
    if (JSON.stringify(distributedPhotovoltaicCustomer) === '{}') distributedPhotovoltaicCustomer = {distributedPvCustomer:0, proportionOfNonResidents:0};

    if (!totalCustomer) throw new BizError(`${interfaceName} 缺少参数 totalCustomer` );
    if (!realTimeMonitoring) throw new BizError(`${interfaceName} 缺少参数 realTimeMonitoring` );
    if (!distributedPvCustomerTrends) throw new BizError(`${interfaceName} 缺少参数 distributedPvCustomerTrends` );
    if (!distributedPhotovoltaicCustomer) throw new BizError(`${interfaceName} 缺少参数 distributedPhotovoltaicCustomer` );
    if (!powerAnalysis) throw new BizError(`${interfaceName} 缺少参数 powerAnalysis` );

    let {residentCustomer, nonResidentCustomer} = totalCustomer;
    //客户总量
    let customerInfo = {
        居民客户: residentCustomer,
        非居民客户: nonResidentCustomer
    };

    //各类污染物减排占比
    let {NO2, CO2, SO2} = realTimeMonitoring;
    let realTimeInfo = {
        NO2: NO2 + "吨",
        CO2: CO2 + "吨",
        SO2: SO2 + "吨"
    };

    //分布式光伏客户接入变化趋势
    let distributed = {};
    distributedPvCustomerTrends.forEach( info => {
        let {year, value} = info;
        distributed[year] = value + "户";
    })

    let {distributedPvCustomer, proportionOfNonResidents} = distributedPhotovoltaicCustomer;
    //分布式光伏客户
    let distributedInfo = {
        分布式光伏客户:distributedPvCustomer + "户",
        非居民占比:proportionOfNonResidents + "%"
    };

    //近12个月电量分析
    let powerAnalysisInfo;
    let powerGenerationData = {};
    let theInternetChargeData = {};
    powerAnalysis.forEach( info => {
        let {month, powerGeneration, theInternetCharge} = info;
        powerGenerationData[month] = powerGeneration + "万kwh";
        theInternetChargeData[month] = theInternetCharge + "万kwh";
    })
    powerAnalysisInfo = {发电量: powerGenerationData, 上网电量: theInternetChargeData};

    return {customerInfo, realTimeInfo, distributed, distributedInfo, powerAnalysisInfo};
}

export async function getPowerGeneration() {
    let interfaceName = "绿色电力清洁能源光伏接入";
    let {totalGeneratingCapacity} = await getInterfaceByInterfaceName(interfaceName);
    
    // -------------------test---------------------
    // let totalGeneratingCapacity:any = {"grossGeneration":0.09,"proportionOfNonResidents":0.00};
    // -------------------end----------------------
    
    if (JSON.stringify(totalGeneratingCapacity) === '{}') totalGeneratingCapacity = {grossGeneration:0, proportionOfNonResidents:0};

    if (!totalGeneratingCapacity) throw new BizError(`${interfaceName} 缺少参数 totalGeneratingCapacity` );

    //总发点量
    let {grossGeneration, proportionOfNonResidents} = totalGeneratingCapacity;
    let powerGenerationInfo = {
        总发电量:grossGeneration + "亿千瓦时",
        非居民占比:proportionOfNonResidents + "%"
    };

    return {powerGenerationInfo};
}

export async function getInstalledCapacity() {
    let interfaceName = "绿色电力清洁能源光伏接入";
    let {theInstalledCapacity} = await getInterfaceByInterfaceName(interfaceName);
    
    // ------------------test--------------
    // let theInstalledCapacity:any = {"installedCapacity":123, "proportionOfNonResidents":4589};
    // ------------------end---------------

    if (JSON.stringify(theInstalledCapacity) === '{}') theInstalledCapacity = {installedCapacity:0, proportionOfNonResidents:0};

    if (!theInstalledCapacity) throw new BizError(`${interfaceName} 缺少参数 theInstalledCapacity` );

    //装机容量
    let {installedCapacity, proportionOfNonResidents} = theInstalledCapacity;
    let installedCapacityInfo = {
        装机容量:installedCapacity + "万千伏安",
        非居民占比:proportionOfNonResidents + "%"
    };

    return {installedCapacityInfo};
}