import { BizError } from "../../util/bizError";
import { getInterfaceByInterfaceName } from "./cronJob";

export async function getJjjqd() {
    let interfaceName = "经济景气度";
    let {basicData, prosperityIndexOfKeyRegions, industrialDistribution, economicSentimentIndex, rangeData} = await getInterfaceByInterfaceName(interfaceName);
    
    // -----------------test-----------------
    // let basicData:any = {demonstrationAreaEconomicProsperity:89.0300, wuJiangDistrict:0.0000, qingPuDistrict:103.6485, jiaShanCounty:0.0000};
    // let prosperityIndexOfKeyRegions:any = {"xiHongQiao":143.8673,"xianXingQiDongArea":149.3286,"qingPuNewTown":112.9732};
    // let industrialDistribution:any = {"constructionIndustry":113.4870,"leasingAndBusinessService":149.7152,"wholesaleAndRetail":108.2574,"financialIndustry":82.8192,"realEstate":113.0102,"informationTechnologyServices":157.9385,"transportationAndWarehousingAndPostalServices":90.0323,"fisheries":121.9266,"industrial":101.3097,"accommodationAndCatering":109.9809,"publicServiceAndManagementOrganization":83.5883};
    // let economicSentimentIndex = [{"year":"2020","trend":102.5900},{"year":"2021","trend":119.6900},{"year":"2022","trend":103.6485}];
    // -----------------end-----------------

    if (JSON.stringify(basicData) === '{}') basicData = {demonstrationAreaEconomicProsperity:0, wuJiangDistrict:0, qingPuDistrict:0, jiaShanCounty:0}
    if (JSON.stringify(prosperityIndexOfKeyRegions) === '{}') prosperityIndexOfKeyRegions = {xiHongQiao:0, xianXingQiDongArea:0, qingPuNewTown:0};
    if (JSON.stringify(industrialDistribution) === '{}') industrialDistribution = {constructionIndustry:0, leasingAndBusinessService:0, wholesaleAndRetail:0, financialIndustry:0, realEstate:0, informationTechnologyServices:0, transportationAndWarehousingAndPostalServices:0, fisheries:0, industrial:0, accommodationAndCatering:0, publicServiceAndManagementOrganization:0};
    if (JSON.stringify(rangeData) === '{}') rangeData = {regionalScope:"", timeRange:""};

    if (!basicData) throw new BizError(`${interfaceName} 缺少参数 basicData` );
    if (!prosperityIndexOfKeyRegions) throw new BizError(`${interfaceName} 缺少参数 prosperityIndexOfKeyRegions` );
    if (!industrialDistribution) throw new BizError(`${interfaceName} 缺少参数 industrialDistribution` );
    if (!economicSentimentIndex) throw new BizError(`${interfaceName} 缺少参数 economicSentimentIndex` );
    if (!rangeData) throw new BizError(`${interfaceName} 缺少参数 rangeData` );

    let basicInfo = {
        示范区经济景气指数: basicData.demonstrationAreaEconomicProsperity,
        吴江区: basicData.wuJiangDistrict,
        青浦区: basicData.qingPuDistrict,
        嘉善县: basicData.jiaShanCounty
    };

    //重点区域景气指数（青浦）
    let prosperity = {
        西虹桥: prosperityIndexOfKeyRegions.xiHongQiao,
        先行启动区: prosperityIndexOfKeyRegions.xianXingQiDongArea,
        青浦新城: prosperityIndexOfKeyRegions.qingPuNewTown
    };

    //行业景气指数
    let {informationTechnologyServices, leasingAndBusinessService, wholesaleAndRetail, realEstate, constructionIndustry, transportationAndWarehousingAndPostalServices, 
        industrial, accommodationAndCatering, publicServiceAndManagementOrganization, fisheries, financialIndustry} = industrialDistribution;
    
    let industrialInfo = {
        '信息技术服务业': informationTechnologyServices,
        '租赁和商务服务业': leasingAndBusinessService,
        '批发和零售业': wholesaleAndRetail,
        '房地产业': realEstate,
        '建筑业': constructionIndustry,
        '交通运输、仓储和邮政服务': transportationAndWarehousingAndPostalServices,
        '工业': industrial,
        '住宿和餐饮业': accommodationAndCatering,
        '公共服务及管理组织': publicServiceAndManagementOrganization,
        '农、林、牧、渔业': fisheries,
        '金融业': financialIndustry
    };

    //经济景气指数趋势分析
    let economicInfo = {};
    economicSentimentIndex.forEach( info => {
        let {year, trend} = info;
        economicInfo[year] = trend;
    })

    //范围数据
    let {regionalScope, timeRange} = rangeData;
    let rangeInfo = {
        "区域范围": regionalScope,
        "时间范围": timeRange
    };

    return {basicInfo, prosperity, industrialInfo, economicInfo, rangeInfo};
}