import { BizError } from "../../util/bizError";
import { getInterfaceByInterfaceName } from "./cronJob";

export async function getHyydfb() {
    let interfaceName = "行业用电分布";
    let {basicData, demonstrationAreaIndustryElectricity, concentrationAnalysisOfKeyIndustries, electricityConsumptionByIndustry, rangeData} = await getInterfaceByInterfaceName(interfaceName);
    
    // ------------------test------------
    // let basicData:any = {demonstrationAreaIndustryElectricity:""};
    // let demonstrationAreaIndustryElectricity:any = {"fisheries":0.35,"industrial":17.25,"constructionIndustry":0.67,"transportationAndWarehousingAndPostalServices":1.03,"informationTechnologyServices":2.64,"wholesaleAndRetail":2.01,"accommodationAndCatering":0.28,"financialIndustry":0.07,"realEstate":3.78,"leasingAndBusinessService":0.35,"publicServiceAndManagementOrganization":2.50};
    // let concentrationAnalysisOfKeyIndustries = [{"month":"202109","travel":68.0200,"informationTechnology":75.1300,"modernLogistics":89.9300},{"month":"202110","travel":66.8200,"informationTechnology":75.4800,"modernLogistics":67.5900}];
    // let electricityConsumptionByIndustry:any = {"qingPuArea":{"农,林,牧,渔业":0.00,"工业":0.00,"建筑业":0.00,"交通运输，仓储和邮政业":0.00,"信息传输,软件和信息技术服务业":0.00,"批发和零售业":0.00,"住宿和餐饮业":0.00,"金融业":0.00,"房地产业":0.00,"租赁和商务服务业":0.00,"公共服务及管理组织":0.00},"wuJiangArea":{"农,林,牧,渔业":0.00,"工业":0.00,"建筑业":0.00,"交通运输，仓储和邮政业":0.00,"信息传输,软件和信息技术服务业":0.00,"批发和零售业":0.00,"住宿和餐饮业":0.00,"金融业":0.00,"房地产业":0.00,"租赁和商务服务业":0.00,"公共服务及管理组织":0.00},"jiaShanCounty":{"农,林,牧,渔业":0.00,"工业":0.00,"建筑业":0.00,"交通运输，仓储和邮政业":0.00,"信息传输,软件和信息技术服务业":0.00,"批发和零售业":0.00,"住宿和餐饮业":0.00,"金融业":0.00,"房地产业":0.00,"租赁和商务服务业":0.00,"公共服务及管理组织":0.00}};
    // let rangeData = {regionalScope:"", timeRange:""};
    // ------------------end------------

    if (JSON.stringify(basicData) === '{}') basicData = {demonstrationAreaIndustryElectricity:0};
    if (JSON.stringify(electricityConsumptionByIndustry) === '{}') electricityConsumptionByIndustry = {"qingPuArea":{"农,林,牧,渔业":0.00,"工业":0.00,"建筑业":0.00,"交通运输，仓储和邮政业":0.00,"信息传输,软件和信息技术服务业":0.00,"批发和零售业":0.00,"住宿和餐饮业":0.00,"金融业":0.00,"房地产业":0.00,"租赁和商务服务业":0.00,"公共服务及管理组织":0.00},"wuJiangArea":{"农,林,牧,渔业":0.00,"工业":0.00,"建筑业":0.00,"交通运输，仓储和邮政业":0.00,"信息传输,软件和信息技术服务业":0.00,"批发和零售业":0.00,"住宿和餐饮业":0.00,"金融业":0.00,"房地产业":0.00,"租赁和商务服务业":0.00,"公共服务及管理组织":0.00},"jiaShanCounty":{"农,林,牧,渔业":0.00,"工业":0.00,"建筑业":0.00,"交通运输，仓储和邮政业":0.00,"信息传输,软件和信息技术服务业":0.00,"批发和零售业":0.00,"住宿和餐饮业":0.00,"金融业":0.00,"房地产业":0.00,"租赁和商务服务业":0.00,"公共服务及管理组织":0.00}};
    if (JSON.stringify(rangeData) === '{}') rangeData = rangeData = {regionalScope:"", timeRange:""};

    if (!basicData) throw new BizError(`${interfaceName} 缺少参数 basicData` );
    if (!rangeData) throw new BizError(`${interfaceName} 缺少参数 rangeData` );

    let basicInfo = {示范区行业用电分布: basicData.demonstrationAreaIndustryElectricity};

    //重点行业集中度年度分析（青浦）
    let concentrationAnalysis = {};
    let ly = {};
    let xxjs = {};
    let xdwl = {};
    concentrationAnalysisOfKeyIndustries.forEach( info => {
        let {month, travel, informationTechnology, modernLogistics} = info;
        ly[month] = travel;
        xxjs[month] = informationTechnology;
        xdwl[month] = modernLogistics;
    })

    concentrationAnalysis = {旅游: ly, 信息技术: xxjs, 现代物流: xdwl};

    //三地各行业用电量
    let electricityInfo;
    let qingPuAreaData = {};
    let wuJiangAreaData = {};
    let jiaShanCountyData = {};
    // electricityConsumptionByIndustry.forEach( info => {
    //     let {industryName, qingPuArea, wuJiangArea, jiaShanCounty} = info;
    //     qingPuAreaData[industryName] = qingPuArea;
    //     wuJiangAreaData[industryName] = wuJiangArea;
    //     jiaShanCountyData[industryName] = jiaShanCounty;
    // })

    let {qingPuArea, wuJiangArea, jiaShanCounty} = electricityConsumptionByIndustry;
    electricityInfo = {青浦区: qingPuArea, 吴江区: wuJiangArea, 嘉善县: jiaShanCounty};
    // electricityInfo = {青浦区: qingPuAreaData, 吴江区: wuJiangAreaData, 嘉善县: jiaShanCountyData};

    //范围数据
    let {regionalScope, timeRange} = rangeData;
    let rangeInfo = {
        "区域范围": regionalScope,
        "时间范围": timeRange
    };

    return {basicInfo, concentrationAnalysis, electricityInfo, rangeInfo};
}

export async function getElectricity() {
    let interfaceName = "行业用电分布";
    let {demonstrationAreaIndustryElectricity} = await getInterfaceByInterfaceName(interfaceName);

    // -----------------test---------------------
    // let demonstrationAreaIndustryElectricity:any = {"fisheries":0.35,"industrial":17.25,"constructionIndustry":0.67,"transportationAndWarehousingAndPostalServices":1.03,"informationTechnologyServices":2.64,"wholesaleAndRetail":2.01,"accommodationAndCatering":0.28,"financialIndustry":0.07,"realEstate":3.78,"leasingAndBusinessService":0.35,"publicServiceAndManagementOrganization":2.50};
    // ------------------end--------------------
    
    if (JSON.stringify(demonstrationAreaIndustryElectricity) === '{}') demonstrationAreaIndustryElectricity = {industrial:0, publicServiceAndManagementOrganization:0, realEstate:0, wholesaleAndRetail:0, informationTechnologyServices:0, transportationAndWarehousingAndPostalServices:0, constructionIndustry:0, accommodationAndCatering:0, fisheries:0, leasingAndBusinessService:0, financialIndustry:0};
    
    //示范区行业用电分布
    let {industrial, publicServiceAndManagementOrganization, realEstate, wholesaleAndRetail, informationTechnologyServices, transportationAndWarehousingAndPostalServices,
        constructionIndustry, accommodationAndCatering, fisheries, leasingAndBusinessService, financialIndustry} = demonstrationAreaIndustryElectricity;

    let areaIndustryElectricity = {
        '工业': industrial + "亿千瓦时",
        '公共服务及管理组织': publicServiceAndManagementOrganization + "亿千瓦时",
        '房地产业': realEstate + "亿千瓦时",
        '批发和零售业': wholesaleAndRetail + "亿千瓦时",
        '信息传输、软件和信息技术服务业': informationTechnologyServices + "亿千瓦时",
        '交通运输、仓储和邮政服务': transportationAndWarehousingAndPostalServices + "亿千瓦时",
        '建筑业': constructionIndustry + "亿千瓦时",
        '住宿和餐饮业': accommodationAndCatering + "亿千瓦时",
        '农、林、牧、渔业': fisheries + "亿千瓦时",
        '租赁和商务服务业': leasingAndBusinessService + "亿千瓦时",
        '金融业': financialIndustry + "亿千瓦时"
    };

    return {areaIndustryElectricity};
} 