import { BizError } from "../../util/bizError";
import { getInterfaceByInterfaceName } from "./cronJob";

export async function getGsqyscyx() {
    let interfaceName = "规上企业生产运行状况";
    let {basicData, productionIndexTrend, rangeData} = await getInterfaceByInterfaceName(interfaceName);
    
    // ------------------test------------
    // let basicData:any = {};
    // let productionIndexTrend = [{"year":"2020","productionIndices":102.59},{"year":"2021","productionIndices":119.69},{"year":"2022","productionIndices":103.65}];
    // ------------------end------------

    if (JSON.stringify(basicData) === '{}') basicData = {productionIndex:0};
    if (JSON.stringify(rangeData) === '{}') rangeData = {regionalScope:"", timeRange:""};

    if(!basicData) throw new BizError(`${interfaceName} 缺少参数 basicData`);
    if(!productionIndexTrend) throw new BizError(`${interfaceName} 缺少参数 demonstrationAreaIndexTrend`);
    if(!rangeData) throw new BizError(`${interfaceName} 缺少参数 rangeData`);

    let {productionIndex} = basicData;
    let basicInfo = {青浦区生产指数: productionIndex};

    //生产指数趋势分析
    let productionInfo = {};
    productionIndexTrend.forEach( info => {
        let {year, productionIndices} = info;
        productionInfo[year] = productionIndices;
    })
    
    //范围数据
    let {regionalScope, timeRange} = rangeData;
    let rangeInfo = {
        "区域范围": regionalScope,
        "时间范围": timeRange
    };

    return {basicInfo, productionInfo, rangeInfo}
}

export async function getIndustrial(name) {
    let interfaceName = "规上企业生产运行状况";
    let {industryProductionIndex, industrialDistribution} = await getInterfaceByInterfaceName(interfaceName);
    
    // ----------------test------------
    // let industryProductionIndex:any = {"industrial":0.00,"transportationAndWarehousingAndPostalServices":0.00,"wholesaleAndRetail":0.00,"leasingAndBusinessService":0.00,"publicServiceAndManagementOrganization":0.00};
    // let industrialDistribution:any = {"industrial":0,"transportationAndWarehousingAndPostalServices":0,"wholesaleAndRetail":0,"leasingAndBusinessService":0,"publicServiceAndManagementOrganization":0};
    // ----------------end-------------

    if (JSON.stringify(industryProductionIndex) === '{}') industryProductionIndex= {industrial:0, wholesaleAndRetail:0, leasingAndBusinessService:0, transportationAndWarehousingAndPostalServices:0, publicServiceAndManagementOrganization:0};
    if (JSON.stringify(industrialDistribution) === '{}') industrialDistribution = {industrial:0, wholesaleAndRetail:0, leasingAndBusinessService:0, transportationAndWarehousingAndPostalServices:0, publicServiceAndManagementOrganization:0};

    if(!industryProductionIndex) throw new BizError(`${interfaceName} 缺少参数 demonstrationAreaIndexTrend`);
    if(!industrialDistribution) throw new BizError(`${interfaceName} 缺少参数 demonstrationAreaIndexTrend`);
    
    let industrial, wholesaleAndRetail, leasingAndBusinessService, transportationAndWarehousingAndPostalServices, publicServiceAndManagementOrganization;
    if(name == "行业生产指数") {
        industrial = industryProductionIndex.industrial;
        wholesaleAndRetail = industryProductionIndex.wholesaleAndRetail;
        leasingAndBusinessService = industryProductionIndex.leasingAndBusinessService;
        transportationAndWarehousingAndPostalServices = industryProductionIndex.transportationAndWarehousingAndPostalServices;
        publicServiceAndManagementOrganization = industryProductionIndex.publicServiceAndManagementOrganization;
    } else if (name == "规上企业行业分布概览") {
        industrial = industrialDistribution.industrial;
        wholesaleAndRetail = industrialDistribution.wholesaleAndRetail;
        leasingAndBusinessService = industrialDistribution.leasingAndBusinessService;
        transportationAndWarehousingAndPostalServices = industrialDistribution.transportationAndWarehousingAndPostalServices;
        publicServiceAndManagementOrganization = industrialDistribution.publicServiceAndManagementOrganization;
    }
    let dataInfo = {
        "工业": industrial,
        "批发和商务服务业": wholesaleAndRetail,
        "租赁和商务服务业": leasingAndBusinessService,
        "交通、运输仓储和邮政业": transportationAndWarehousingAndPostalServices,
        "公共服务及管理组织": publicServiceAndManagementOrganization
    };

    return {dataInfo};
}