import { BizError } from "../../util/bizError";
import { getInterfaceByInterfaceName } from "./cronJob";

export async function getCsqxtfz() {
    let interfaceName = "城市群协同发展";
    let {basicData, demonstrationAreaIndexTrend, rangeData} = await getInterfaceByInterfaceName(interfaceName);
    
    // ------------test----------
    // let basicData:any = {"regionalIndex":116.6800,"economic":114.4600,"nonAgriculturalIndustries":114.3100,"resourcesEndowment":120.0800};
    // let demonstrationAreaIndexTrend = [{"month":"202101","value":113.2200},{"month":"202102","value":114.2700},{"month":"202103","value":110.6700},{"month":"202104","value":109.2500},{"month":"202105","value":113.6700},{"month":"202106","value":110.4300},{"month":"202107","value":108.5300},{"month":"202108","value":107.8500},{"month":"202109","value":107.6900},{"month":"202110","value":106.2300},{"month":"202111","value":104.5900},{"month":"202112","value":103.7000},{"month":"202201","value":127.1400},{"month":"202202","value":134.9100},{"month":"202203","value":122.9900},{"month":"202204","value":116.6800}];
    // ------------end------------

    if (JSON.stringify(basicData) === '{}')  basicData = {regionalIndex:0, economic:0, nonAgriculturalIndustries:0, resourcesEndowment:0};
    if (JSON.stringify(rangeData) === '{}')  rangeData = {regionalScope:"", timeRange:""};

    if(!basicData) throw new BizError(`${interfaceName} 缺少参数 basicData`);
    if(!demonstrationAreaIndexTrend) throw new BizError(`${interfaceName} 缺少参数 demonstrationAreaIndexTrend`);
    if(!rangeData) throw new BizError(`${interfaceName} 缺少参数 rangeData`);

    let {regionalIndex, economic, nonAgriculturalIndustries, resourcesEndowment} = basicData;
    let basicInfo = {
        区域协同发展指数: regionalIndex,
        经济协同发展: economic,
        非农产业协同发展: nonAgriculturalIndustries,
        资源禀赋协同发展: resourcesEndowment
    };

    //长三角示范区一体化协同发展指数趋势
    let demonstrationInfo = {};
    demonstrationAreaIndexTrend.forEach( info => {
        let {month, value} = info;
        demonstrationInfo[month] = value;
    })

    //范围数据
    let {regionalScope, timeRange} = rangeData;
    let rangeInfo = {
        "区域范围": regionalScope,
        "时间范围": timeRange
    };

    return {basicInfo, demonstrationInfo, rangeInfo}
}

export async function getArea(area) {
    let interfaceName = "城市群协同发展";
    let {wujiangDistriceData, qinpuDistriceData, jiashanDistriceData} = await getInterfaceByInterfaceName(interfaceName);
    
    // ------------test----------
    // let wujiangDistriceData:any = {"deJurePopulation":0.0000,"ardeJurePopulationea":0.0000,"GDP":0.0000,"totalElectricityConsumption":0.0000,"cumulativeInstallationCapacity":0.0000,"maximumSociallload":0.0000};
    // let qinpuDistriceData:any = {"deJurePopulation":0.0000,"ardeJurePopulationea":0.0000,"GDP":0.0000,"totalElectricityConsumption":0.0000,"cumulativeInstallationCapacity":0.0000,"maximumSociallload":0.0000};
    // let jiashanDistriceData:any = {"deJurePopulation":0.0000,"ardeJurePopulationea":0.0000,"GDP":0.0000,"totalElectricityConsumption":0.0000,"cumulativeInstallationCapacity":0.0000,"maximumSociallload":0.0000};
    // ------------end------------

    if (JSON.stringify(wujiangDistriceData) === '{}') wujiangDistriceData = {deJurePopulation:0, ardeJurePopulationea:0, GDP:0, totalElectricityConsumption:0, cumulativeInstallationCapacity:0, maximumSociallload:0};
    if (JSON.stringify(qinpuDistriceData) === '{}') qinpuDistriceData = {deJurePopulation:0, ardeJurePopulationea:0, GDP:0, totalElectricityConsumption:0, cumulativeInstallationCapacity:0, maximumSociallload:0};
    if (JSON.stringify(jiashanDistriceData) === '{}') jiashanDistriceData = {deJurePopulation:0, ardeJurePopulationea:0, GDP:0, totalElectricityConsumption:0, cumulativeInstallationCapacity:0, maximumSociallload:0};

    if(!wujiangDistriceData) throw new BizError(`${interfaceName} 缺少参数 wujiangDistriceData`);
    if(!qinpuDistriceData) throw new BizError(`${interfaceName} 缺少参数 qinpuDistriceData`);
    if(!jiashanDistriceData) throw new BizError(`${interfaceName} 缺少参数 jiashanDistriceData`);

    let deJurePopulation;
    let ardeJurePopulationea;
    let GDP;
    let totalElectricityConsumption;
    let maximumSociallload;
    let cumulativeInstallationCapacity;

    if(area == "吴江") {
        deJurePopulation = wujiangDistriceData.deJurePopulation;
        ardeJurePopulationea = wujiangDistriceData.ardeJurePopulationea;
        GDP = wujiangDistriceData.GDP;
        totalElectricityConsumption = wujiangDistriceData.totalElectricityConsumption;
        maximumSociallload = wujiangDistriceData.maximumSociallload;
        cumulativeInstallationCapacity = wujiangDistriceData.cumulativeInstallationCapacity;
    } else if(area == "青浦") {
        deJurePopulation = qinpuDistriceData.deJurePopulation;
        ardeJurePopulationea = qinpuDistriceData.ardeJurePopulationea;
        GDP = qinpuDistriceData.GDP;
        totalElectricityConsumption = qinpuDistriceData.totalElectricityConsumption;
        maximumSociallload = qinpuDistriceData.maximumSociallload;
        cumulativeInstallationCapacity = qinpuDistriceData.cumulativeInstallationCapacity;
    } else if(area == "嘉善") {
        deJurePopulation = jiashanDistriceData.deJurePopulation;
        ardeJurePopulationea = jiashanDistriceData.ardeJurePopulationea;
        GDP = jiashanDistriceData.GDP;
        totalElectricityConsumption = jiashanDistriceData.totalElectricityConsumption;
        maximumSociallload = jiashanDistriceData.maximumSociallload;
        cumulativeInstallationCapacity = jiashanDistriceData.cumulativeInstallationCapacity;
    }

    let dataInfo = {
        常住人口: deJurePopulation,
        面积: ardeJurePopulationea,
        GDP: GDP,
        全社会用电量: totalElectricityConsumption,
        全社会最大负荷: maximumSociallload,
        累计装接容量: cumulativeInstallationCapacity
    };

    return {dataInfo}
}
