import { BizError } from "../../util/bizError";
import { getInterfaceByInterfaceName } from "./cronJob";

export async function getCdssfzjk() {
    let interfaceName = "绿色电力充电设施发展监控";
    let {chargingFacilities, realTimeMonitoring, monthlyService} = await getInterfaceByInterfaceName(interfaceName);

    // let chargingFacilities:any = {};
    // let realTimeMonitoring:any = {};
    // let monthlyService = [{"dateTime":"202202","frequency":11081},{"dateTime":"202203","frequency":9480},{"dateTime":"202204","frequency":2833},{"dateTime":"202205","frequency":4830},{"dateTime":"202206","frequency":16926}];

    if (JSON.stringify(chargingFacilities) === '{}') chargingFacilities = {chargingStationNumber:0, chargingPileNumber:0, prioritiesInTheSite:0};
    if (JSON.stringify(realTimeMonitoring) === '{}') realTimeMonitoring = {theTotalChargeOn:0, totalCharge:0, chargeAmount:0};
    if (!chargingFacilities) throw new BizError(`${interfaceName} 缺少参数 chargingFacilities` );
    if (!realTimeMonitoring) throw new BizError(`${interfaceName} 缺少参数 realTimeMonitoring` );
    if (!monthlyService) throw new BizError(`${interfaceName} 缺少参数 monthlyService` );

    //充电设施发展监控
    let {chargingStationNumber, chargingPileNumber, prioritiesInTheSite} = chargingFacilities;
    let chargingInfo = {
        "充电站数(国网自建)":chargingStationNumber + "座",
        "充电桩数(国网自建)":chargingPileNumber + "座",
        "国网在建数":prioritiesInTheSite + "座"
    };

    //服务车次
    let {theTotalChargeOn, totalCharge, chargeAmount} = realTimeMonitoring;
    let realTimeMonitoringInfo = {
        "总充电车次":theTotalChargeOn + "次",
        "总充电总量":totalCharge + "万千瓦时",
        "充电金额":chargeAmount + "万元"
    };
    
    //每月服务车次
    let monthInfo = {};
    monthlyService.forEach( info => {
        let {dateTime, frequency} = info;
        monthInfo[dateTime] = frequency + "次";
    })

    return {chargingInfo, realTimeMonitoringInfo, monthInfo}
}