let fs = require('fs');
let apiInfoList = [
    {name:"FuHuaZaiTi", dataList:[
        {name:"孵化载体", len:4, type:"键值", strType:"c",strLen:4, valLen:2, haveUnit:false},
        {name:"孵化载体占比数据", len:2, type:"键值", strType:"c", strLen:5, valLen:1, haveUnit:true}, 
        {name:"孵化载体数量趋势", len:11, type:"柱状"}, 
        {name:"孵化载体投资主体", len:3, type:"键值", strType:"c",strLen:2, valLen:2, haveUnit:false}, 
        {name:"孵化载体行业分类", len:5, type:"键值", strType:"c",strLen:4, valLen:2, haveUnit:false}, 
        {name:"孵化载体运营", len:5, type:"键值", strType:"c",strLen:2, valLen:3, haveUnit:false}, 
        {name:"平均营收趋势", len:7, type:"柱状"}, 
        {name:"重要评价指标", len:4, type:"键值", strType:"c",strLen:5, valLen:3, haveUnit:false}, 
        {name:"服务资源", len:8, type:"键值", strType:"c",strLen:10, valLen:3, haveUnit:false}, 
        {name:"政策服务", len:2, type:"键值", strType:"c",strLen:3, valLen:4, haveUnit:false}, 
        {name:"地图数据", len:100, type:"地图"}
    ]},
    {name:"KeJiJinRong", dataList:[
        {name:"上市企业板块分布", len:8, type:"键值", strType:"c",strLen:4, valLen:3, haveUnit:true}, 
        {name:"科创版企业", len:10, type:"键值", strType:"c",strLen:6, valLen:2, haveUnit:true}, 
        {name:"挂牌企业", len:4, type:"键值", strType:"c",strLen:4, valLen:2, haveUnit:false}, 
        {name:"2020年企业融资情况", len:3, type:"键值", strType:"c",strLen:4, valLen:2, haveUnit:false}, 
        {name:"2020年企业上市情况", len:3, type:"键值", strType:"c",strLen:5, valLen:2, haveUnit:false}, 
        {name:"融资金额趋势", len:17, type:"柱状"}, 
        {name:"上市企业行业分布", len:5, type:"键值", strType:"c",strLen:4, valLen:2, haveUnit:false},
        {name:"创投机构", len:4, type:"键值", strType:"c",strLen:4, valLen:2, haveUnit:true},
        {name:"融资企业行业分布", len:8, type:"键值", strType:"c",strLen:7, valLen:2, haveUnit:true}, 
        {name:"企业融资阶段分布", len:12, type:"键值", strType:"c",strLen:6, valLen:3, haveUnit:true}, 
        {name:"金融产品担保方式占比", len:7, type:"键值", strType:"c",strLen:6, valLen:2, haveUnit:true}, 
        {name:"中央球展示数据",  len:5, type:"键值", strType:"c",strLen:5, valLen:3, haveUnit:true}
    ]},
    {name:"QiYePeiYu", dataList:[
        {name:"企业特征", len:5, type:"键值", strType:"c",strLen:4, valLen:3, haveUnit:false}, 
        {name:"代表企业", len:0, type:""}, 
        {name:"海外项目", len:7, type:"键值", strType:"c",strLen:4, valLen:2, haveUnit:true}, 
        {name:"人才引进", len:7, type:"键值", strType:"c",strLen:6, valLen:4, haveUnit:true}, 
        {name:"营业收入TOP5", len:5, type:"键值", strType:"c",strLen:12, valLen:1, haveUnit:true},
        {name:"净利润TOP5", len:5, type:"键值", strType:"c",strLen:12, valLen:1, haveUnit:true}, 
        {name:"研发投入TOP5", len:5, type:"键值", strType:"c",strLen:12, valLen:1, haveUnit:true}, 
        {name:"入孵企业数量趋势", len:11, type:"柱状"}, 
        {name:"孵化器2020入驻企业数量排名", len:5, type:"键值", strType:"c",strLen:10, valLen:3, haveUnit:false}, 
        {name:"运营指标趋势", len:17, type:"柱状"}, 
        {name:"企业运营情况", len:5, type:"键值", strType:"c",strLen:5, valLen:3, haveUnit:true}, 
        {name:"企业运营概况", len:5, type:"键值", strType:"c",strLen:4, valLen:5, haveUnit:true}, 
        {name:"科技创新", len:5, type:"键值", strType:"c",strLen:4, valLen:5, haveUnit:false}, 
        {name:"发明专利申请与授权数比例", len:6, type:"柱状"}, 
        {name:"高新技术企业数据概况", len:3, type:"键值", strType:"c",strLen:4, valLen:3, haveUnit:true}, 
        {name:"高新技术企业培育", len:5, type:"柱状"}, 
        {name:"企业融资", len:4, type:"键值", strType:"c",strLen:4, valLen:3, haveUnit:false}, 
        {name:"2020四季度重大融资事件", len:5, type:"键值", strType:"c",strLen:8, valLen:3, haveUnit:true}
    ]},
    {name:"RongTongHua", dataList:[
        {name: "大中小企业融通发展联盟", len:2, type:"键值", strType:"c",strLen:4, valLen:3, haveUnit:false}, 
        {name: "主要成效", len:5, type:"键值", strType:"c",strLen:10, valLen:3, haveUnit:false}, 
        {name: "创业加速营", len:1, type:"键值", strType:"c",strLen:7, valLen:1, haveUnit:false}, 
        {name: "大企业开放式创新平台", len:3, type:"键值", strType:"c",strLen:3, valLen:1, haveUnit:false}, 
        {name: "大企业服务和成果", len:4, type:"键值", strType:"c",strLen:4, valLen:2, haveUnit:false}, 
        {name: "地图数据", len:22, type:"地图"}
    ]},
    {name:"ShuangChuangShengTai", dataList:[
        {name:"双创集群", len:7, type:"键值", strType:"c",strLen:8, valLen:3, haveUnit:true}, 
        {name:"孵化器增长趋势", len:6, type:"柱状"}, 
        {name:"企业培育", len:3, type:"键值", strType:"c",strLen:6, valLen:3, haveUnit:true}, 
        {name:"行业分布", len:5, type:"键值", strType:"c",strLen:4, valLen:3, haveUnit:true}, 
        {name:"张江大中小企业融通发展联盟", len:2, type:"键值", strType:"c",strLen:4, valLen:2, haveUnit:false}, 
        {name:"大企业开放式创新平台", len:3, type:"键值", strType:"c",strLen:6, valLen:1, haveUnit:true},
        {name:"科技金融", len:3, type:"键值", strType:"c",strLen:6, valLen:3, haveUnit:true}, 
        {name:"股权融资趋势", len:6, type:"柱状"}, 
        {name:"地图数据", len:8, type:"地图"}
    ]}
];

function createBiz() {
    apiInfoList.forEach(apiInfo=>{
        let path = `./biz/${apiInfo.name}.ts`;
        fs.access(path, (err) => {
            if (!err) {
              console.error(path, "文件已存在");
              return;
            }
          
            fs.writeFileSync(path, getBizFileData(apiInfo.dataList));
            console.log(path, "创建文件成功")
        });
    })    
}

function createRouter() {
    let path = `./routers/router.ts`;
    fs.access(path, (err) => {
        if (!err) {
            console.error(path, "文件已存在");
            return;
        }
        
        fs.writeFileSync(path, getRouterFileData(apiInfoList));
        console.log(path, "创建文件成功")
    });
}

function getBizFileData(dataList) {
    let funStr = "";
    let runFunStr = "";
    let mockFunStr = "";
    dataList.forEach(dataInfo=>{
        let subFunStr = ``;

        switch(dataInfo.type) {
            case "键值" : subFunStr = `mock键值数据模板(${dataInfo.len}, ${dataInfo.strLen}, '${dataInfo.strType}', ${dataInfo.valLen}, ${dataInfo.haveUnit})`;  break;
            case "柱状" : subFunStr = `mock柱状图数据模板(${dataInfo.len})`;  break;
            case "地图" : subFunStr = `mock地图数据模板(${dataInfo.len})`;  break;
        };
        funStr += 
`function get${dataInfo.name}() {
    return ${subFunStr};
}

`;

        runFunStr += 
`    ret["${dataInfo.name}"] = get${dataInfo.name}();
`
    });


    let allData = 
`import { mock柱状图数据模板, mock键值数据模板, mock地图数据模板} from "../util/mockData";

export async function getData(req, res) {
    let ret:any = {};

${runFunStr}

    res.send(ret);
}

${funStr}
`

    return allData;
}

function getRouterFileData(apiInfoList) {
    let importStr = "";
    let listenStr = "";
    apiInfoList.forEach(apiInfo=>{
        importStr +=
`import * as ${apiInfo.name}Biz from '../biz/${apiInfo.name}';
`
        listenStr +=
`    httpServer.get('/${apiInfo.name}', asyncHandler(${apiInfo.name}Biz.getData));
`
    })
    let allDataStr = 
    `import * as asyncHandler from 'express-async-handler'
${importStr}

export function setRouter(httpServer) {
${listenStr}
}`

    return allDataStr;
}

createBiz();
createRouter();