
import { getChartData, getKeyValue, getListData, getSingleYAndMoreData, getMoreYChartData, objKeyReplace }from "../util/tools";
import { get区域融合 } from "../data/analysisExcelData";


function 特化一体化电网运行管理(number) {
    let checkData = new Date().valueOf() - new Date('2021-10-25 00:00:00').valueOf();
    return Math.floor(checkData / (3600 * 1000 * 24)) + number;
}

export function getData(req, res) {
    let ret:any = {};

    let excelData:any = get区域融合();

    // ret["api1"] = getSingleYAndMoreData("各区受理量对比", excelData.各区受理量对比, false, '次');

    // ret["api2"] = getSingleYAndMoreData("各区办结量对比", excelData.各区办结量对比, false, '次');

    let 一体化电网运行管理DataAndUnit = objKeyReplace(excelData.一体化电网运行管理);
    ret["api3"] = getKeyValue("一体化电网运行管理", 一体化电网运行管理DataAndUnit.dataMap, 一体化电网运行管理DataAndUnit.unitMap, true, false );
    ret["api3"].list.forEach(info => {
        info.value = 特化一体化电网运行管理(info.value);
    });


    ret["api4"] = getListData("工程进度",excelData.工程进度,["工程名称","开始时间","预计完成时间","工程进度"],{"工程名称":"name","开始时间":"startTime","预计完成时间":"endTime","工程进度":"rate"});

    // ret["api5"] = getListData("调度日志",excelData.调度日志,["状态","序号","时间","申请人","所属区域","管理单位","业务分类"],{"状态":"state","序号":"number","时间":"time","申请人":"name","所属区域":"area","管理单位":"department","业务分类":"type"});

    ret["api6"] = getSingleYAndMoreData("电网作业风险事件", excelData.电网作业风险事件, false, 'false');

    let 一体化新型电力系统DataAndUnit = objKeyReplace(excelData.一体化新型电力系统);
    ret["api7"] =  getKeyValue("一体化新型电力系统", 一体化新型电力系统DataAndUnit.dataMap, 一体化新型电力系统DataAndUnit.unitMap, false, false );


    //ret["api8"]

    // let 企业客户_一码通识_DataAndUnit = objKeyReplace(excelData.企业客户_一码通识_);
    // ret["api9"] =  getKeyValue("企业客户“一码通识”", 企业客户_一码通识_DataAndUnit.dataMap, 企业客户_一码通识_DataAndUnit.unitMap, false, false );

    // let 用电状态可_分色识别_DataAndUnit = objKeyReplace(excelData.用电状态可_分色识别_);
    // ret["api10"] =  getKeyValue("用电状态可“分色识别”", 用电状态可_分色识别_DataAndUnit.dataMap, 用电状态可_分色识别_DataAndUnit.unitMap, false, false );

    // let 针对性供电服务_随码跟进_DataAndUnit = objKeyReplace(excelData.针对性供电服务_随码跟进_);
    // ret["api11"] =  getKeyValue("针对性供电服务“_随码跟进”", 针对性供电服务_随码跟进_DataAndUnit.dataMap, 针对性供电服务_随码跟进_DataAndUnit.unitMap, false, false );

    // let 营商业务便利性DataAndUnit = objKeyReplace(excelData.营商业务便利性);
    // ret["api12"] =  getKeyValue("营商业务便利性", 营商业务便利性DataAndUnit.dataMap, 营商业务便利性DataAndUnit.unitMap, false, false );

    // let 供电可靠性DataAndUnit = objKeyReplace(excelData.供电可靠性);
    // ret["api13"] =  getKeyValue("供电可靠性", 供电可靠性DataAndUnit.dataMap, 供电可靠性DataAndUnit.unitMap, false, false );

    // let 营商业务及时性DataAndUnit = objKeyReplace(excelData.营商业务及时性);
    // ret["api14"] =  getKeyValue("营商业务及时性", 营商业务及时性DataAndUnit.dataMap, 营商业务及时性DataAndUnit.unitMap, false, false );

    // let 业务三地对标DataAndUnit = objKeyReplace(excelData.业务三地对标);
    // ret["api15"] =  getKeyValue("业务三地对标", 业务三地对标DataAndUnit.dataMap, 业务三地对标DataAndUnit.unitMap, false, false );

    let 嘉善县DataAndUnit = objKeyReplace(excelData.嘉善县);
    ret["api16"] =  getKeyValue("嘉善县",  嘉善县DataAndUnit.dataMap,  嘉善县DataAndUnit.unitMap, false, false );
    let 吴江区DataAndUnit = objKeyReplace(excelData.吴江区);
    ret["api17"] =  getKeyValue("吴江区",  吴江区DataAndUnit.dataMap,  吴江区DataAndUnit.unitMap, false, false );
    let 青浦区DataAndUnit = objKeyReplace(excelData.青浦区);
    ret["api18"] =  getKeyValue("青浦区",  青浦区DataAndUnit.dataMap,  青浦区DataAndUnit.unitMap, false, false );

    ret["api19"] = getListData("值班管理", excelData.值班管理, ["名称", "是否到岗"] , {"名称":"name", "是否到岗":"state"});
    

    let 地图链接数据 = { 
        title: "地图链接",
        subTitle : "地图链接",
        total : 0,
        list : []
    };
    for (let key in excelData.地图链接) {
        地图链接数据.list.push({"key":key, "value": excelData.地图链接[key] });
    }
    ret["api20"] = 地图链接数据;
    
    // for (let key in  excelData.营商业务互动性) {
    //     excelData.营商业务互动性[key] = "";
    // }
    // ret["api21"] = getKeyValue("营商业务互动性", excelData.营商业务互动性, false, false,false);

    ret["api22"] = { title:"图片", data:{
        "img1":"img/qyrh1.png",
        "img2":"img/qyrh2.gif"
    } };

    ret["api23"] = getListData("检修计划",excelData.调度日志_检修计划, ["序号","区域","工作内容","日期"],{"序号":"number","区域":"area","工作内容":"info","日期":"time"});
    ret["api24"] = getListData("故障抢修",excelData.调度日志_故障抢修, ["序号","区域","工作内容","日期"],{"序号":"number","区域":"area","工作内容":"info","日期":"time"});
    ret["api25"] = getListData("停电停役",excelData.调度日志_停电停役, ["序号","区域","工作内容","日期"],{"序号":"number","区域":"area","工作内容":"info","日期":"time"});
    ret["api26"] = getListData("设备缺陷",excelData.调度日志_设备缺陷, ["序号","区域","工作内容","日期"],{"序号":"number","区域":"area","工作内容":"info","日期":"time"});
    ret["api27"] = getListData("事故异常",excelData.调度日志_事故异常, ["序号","区域","工作内容","日期"],{"序号":"number","区域":"area","工作内容":"info","日期":"time"});
    
    ret["api28"] = 特化营商环境("营商环境", "青浦区", excelData.供电可靠性_青浦区, excelData.营商业务便利性_青浦区, excelData.营商业务及时性_青浦区, excelData.营商业务互动性_青浦区);
    ret["api29"] = 特化营商环境("营商环境", "嘉善县", excelData.供电可靠性_嘉善县, excelData.营商业务便利性_嘉善县, excelData.营商业务及时性_嘉善县, excelData.营商业务互动性_嘉善县);
    ret["api30"] = 特化营商环境("营商环境", "吴江区", excelData.供电可靠性_吴江区, excelData.营商业务便利性_吴江区, excelData.营商业务及时性_吴江区, excelData.营商业务互动性_吴江区);


     let _码上办_实时监测DataAndUnit = objKeyReplace(excelData._码上办_实时监测);
    ret["api31"] =  getKeyValue("“码上办”实时监测", _码上办_实时监测DataAndUnit.dataMap, _码上办_实时监测DataAndUnit.unitMap, true, false );

    let _码上办_监测结果DataAndUnit = objKeyReplace(excelData._码上办_监测结果);
    ret["api32"] =  getChartData("“码上办”监测结果", _码上办_监测结果DataAndUnit.dataMap, "户", false );

    let _码上办_政策提示DataAndUnit = objKeyReplace(excelData._码上办_政策提示);
    ret["api33"] =  getKeyValue("“码上办”政策提示", _码上办_政策提示DataAndUnit.dataMap, _码上办_政策提示DataAndUnit.unitMap, false, false );

    res.send(ret);
}

function 特化营商环境(title, subTitle, 供电可靠性, 营商业务便利性, 营商业务及时性, 营商业务互动性) {
    let data:any = {title, subTitle, dataList:[] };

    let 营商业务便利性DataAndUnit = objKeyReplace(营商业务便利性);
    let ysywblxData = {title:"营商业务便利性", data:[]};
    for (let key in 营商业务便利性DataAndUnit.dataMap) {
        
        ysywblxData.data.push({
            key,
            value:营商业务便利性DataAndUnit.dataMap[key],
            unit:营商业务便利性DataAndUnit.unitMap[key]
        });
    }
    data.dataList.push(ysywblxData);



    let 供电可靠性DataAndUnit = objKeyReplace(供电可靠性);
    let gdkkxData = {title:"供电可靠性", data:[]};
    for (let key in 供电可靠性DataAndUnit.dataMap) {
        
        gdkkxData.data.push({
            key,
            value:供电可靠性DataAndUnit.dataMap[key],
            unit:供电可靠性DataAndUnit.unitMap[key]
        });
    }
    data.dataList.push(gdkkxData);

    let 营商业务及时性DataAndUnit = objKeyReplace(营商业务及时性);
    let ysywjsxData = {title:"营商业务及时性", data:[]};
    for (let key in 营商业务及时性DataAndUnit.dataMap) {
        
        ysywjsxData.data.push({
            key,
            value:营商业务及时性DataAndUnit.dataMap[key],
            unit:营商业务及时性DataAndUnit.unitMap[key]
        });
    }
    data.dataList.push(ysywjsxData);

    let ysywhdx = {title:"营商业务互动性", data:[]};
    for (let key in  营商业务互动性) {
        ysywhdx.data.push({key, value:""});
    }
    data.dataList.push(ysywhdx);

    return data;
}

export function get线路负载率(req, res) {
    let excelData:any = get区域融合();

    let ret = {};
    let 线路负荷率数据 = {};
    let 线路负荷率单位 = {};
    let 最大额定容量数据 = {};
    let 最大额度容量单位 = {};
    excelData.线路负荷率.forEach(info => {
        let {max, min, name, maxNum} = info;
        let maxData = parseFloat(max.replace(/[\u4E00-\u9FA5a-zA-Z]+/,""));
        let minData=  parseFloat(min.replace(/[\u4E00-\u9FA5a-zA-Z]+/,""));
        let value =  Math.floor( ((Math.random() * (maxData - minData) ) + minData ) * 100 ) / 100;
        线路负荷率数据[name] = value;
        线路负荷率单位[name] = "%";
        let maxNumData = parseFloat(maxNum.replace(/[\u4E00-\u9FA5a-zA-Z]+/,""));
        最大额定容量数据[name] = maxNumData;
        最大额度容量单位[name] = 'MW'
    });
    let keyValueData =  getKeyValue("线路负荷率", 线路负荷率数据, 线路负荷率单位, false, false );

    keyValueData.list.forEach( info => {
        info["max"] = 最大额定容量数据[info.key];
        info["maxUnit"] = 最大额度容量单位[info.key];
    });
    ret["api1"] = keyValueData;


    res.send(ret);
}
