
    import { getChartData, getKeyValue, getListData, getSingleYAndMoreData, getMoreYChartData, objKeyReplace, analysisAddOrRMData, getDropMoreData }from "../util/tools";
    import { get绿色电力_清洁能源光伏接入情况 } from "../data/analysisExcelData";
    
    export function getData(req, res) {
        let ret:any = {};

        let excelData:any = get绿色电力_清洁能源光伏接入情况();
        
        let 特化数据 = {};
        for (let key in excelData.当期绿电指数) {
            特化数据[key] = analysisAddOrRMData(excelData.当期绿电指数[key]);
        }
        let 当期绿电指数DataAndUnit = objKeyReplace(特化数据);
        ret["api1"] =  getKeyValue("当期绿电指数", 当期绿电指数DataAndUnit.dataMap, 当期绿电指数DataAndUnit.unitMap, false, false );
    
        // let 客户总量DataAndUnit = objKeyReplace(excelData.客户总量);
        // ret["api2"] =  getKeyValue("客户总量", 客户总量DataAndUnit.dataMap, 客户总量DataAndUnit.unitMap, false, false );
    
        let 各类污染物减排占比DataAndUnit = objKeyReplace(excelData.各类污染物减排占比);
        ret["api3"] =  getKeyValue("各类污染物减排占比", 各类污染物减排占比DataAndUnit.dataMap, 各类污染物减排占比DataAndUnit.unitMap, true, false );
    
        // let 清洁能源光伏接入情况DataAndUnit = objKeyReplace(excelData.清洁能源光伏接入情况);
        // let 清洁能源光伏接入情况数据 = {};
        // for (let key in 清洁能源光伏接入情况DataAndUnit.dataMap) {
        //     let value = Math.ceil(清洁能源光伏接入情况DataAndUnit.dataMap[key] * 100)/100;
        //     清洁能源光伏接入情况数据[key] = value;
        // }
        // getKeyValue("清洁能源光伏接入情况", 清洁能源光伏接入情况数据, 清洁能源光伏接入情况DataAndUnit.unitMap, false, false );
        const 分布式光伏客户DataAndUnit = objKeyReplace(excelData.分布式光伏客户);
        const 总发电量DataAndUnit = objKeyReplace(excelData.总发电量);
        const 装机容量DataAndUnit = objKeyReplace(excelData.装机容量);
        
        ret["api4"] = 特化清洁能源接入情况("清洁能源光伏接入情况", 分布式光伏客户DataAndUnit, 总发电量DataAndUnit, 装机容量DataAndUnit );
        
    
        ret["api5"] = getChartData("分布式光伏客户接入变化趋势", excelData.分布式光伏客户接入变化趋势, '户', false );
    
        ret["api6"] = getChartData("绿电指数折线图", excelData.绿电指数折线图, false, false );
    
        ret["api7"] = getSingleYAndMoreData("近12个月电量分析", excelData.近12个月电量分析, false, '万千瓦时');
    
        ret["api8"] = getSingleYAndMoreData("各指数成分趋势分析", excelData.各指数成分趋势分析, false, false);
    
        // ret["api9"] = getMoreYChartData("同比趋势分析", excelData.同比趋势分析, false, {"绿电指数":"单位","同比增长":"%"});
    
        // ret["api10"] = getMoreYChartData("环比趋势分析", excelData.环比趋势分析, false, {"绿电指数":"单位","同比增长":"%"});

        const 指标数据 = [];
        excelData.当期指数分四象限分析指标.forEach(info => {
            let checkInfo:any = objKeyReplace(info);
            指标数据.push(checkInfo.dataMap.x, checkInfo.dataMap.y);
        });

        let 当期指数分四象限分析数据 = [];
        for (let key in excelData.当期指数分四象限分析) {
            let {x, y, name} = excelData.当期指数分四象限分析[key];
            let info = {x:Math.floor(parseFloat(x) * 100 )/100, y:Math.floor(parseFloat(y) * 10000 )/100 , name};
            当期指数分四象限分析数据.push(info);
        }
        
        ret["api11"] = getDropMoreData(当期指数分四象限分析数据, "当期指数分四象限分析", "当期指数分四象限分析", 指标数据);


        // ret["api12"] = getKeyValue("分布式光伏客户", 分布式光伏客户DataAndUnit.dataMap, 分布式光伏客户DataAndUnit.unitMap, false, false);
        // ret["api13"] = getKeyValue("总发电量", 总发电量DataAndUnit.dataMap, 总发电量DataAndUnit.unitMap, false, false);
        // ret["api14"] = getKeyValue("装机容量", 装机容量DataAndUnit.dataMap, 装机容量DataAndUnit.unitMap, false, false);
    
        res.send(ret);
    }

    function 特化清洁能源接入情况(title, 分布式光伏客户DataAndUnit, 总发电量DataAndUnit, 装机容量DataAndUnit,) {
        let result = {
            title, 
            subTitle : title,
            total : 0,
            list : []
        };
        let 分布式光伏客户Unit = 分布式光伏客户DataAndUnit.unitMap;
        let 分布式光伏客户Data = 分布式光伏客户DataAndUnit.dataMap;
        result.list.push({
            key:"分布式光伏客户", 
            value:分布式光伏客户Data["分布式光伏客户"], 
            unit:分布式光伏客户Unit["分布式光伏客户"], 
            rateName:"非居民占比", 
            rate:分布式光伏客户Data["非居民占比"]
        });

        let 总发电量Unit = 总发电量DataAndUnit.unitMap;
        let 总发电量Data = 总发电量DataAndUnit.dataMap;
        result.list.push({
            key:"总发电量", 
            value:总发电量Data["总发电量"], 
            unit:总发电量Unit["总发电量"], 
            rateName:"非居民占比", 
            rate:总发电量Data["非居民占比"]
        });

        let 装机容量Unit = 装机容量DataAndUnit.unitMap;
        let 装机容量Data = 装机容量DataAndUnit.dataMap;
        result.list.push({
            key:"装机容量", 
            value:装机容量Data["装机容量"], 
            unit:装机容量Unit["装机容量"], 
            rateName:"非居民占比", 
            rate:装机容量Data["非居民占比"]
        });

        return result;
    }

    
    