import { get智慧电眼_住宅空置率 } from "../../data/analysisExcelData";
import { getHousingVacancyRate, getIdleUserPower, getResidentialVacancyRate, getTypicalResidentialVacancyTrends, getVacantHouseholdsInKeyAreas, getZzkzl } from "../../data/interface/zzkzl";
import { getChartData, getKeyValue, getListData, getSingleYAndMoreData, getMoreYChartData, objKeyReplace, analysisAddOrRMData, getKeyStringValue }from "../../util/tools";


export async function getData(req, res) {
    let ret:any = {};

    let interfaceData = await getZzkzl();
    let idleInterface = await getIdleUserPower();
    let rateInterface = await getResidentialVacancyRate();
    let areasInterface = await getVacantHouseholdsInKeyAreas();
    let trendsInterface = await getTypicalResidentialVacancyTrends();
    let housingInterface = await getHousingVacancyRate();

    let 空置户特化数据 = {};
    for (let key in interfaceData.vacantHouseholdInfo) {
        空置户特化数据[key] = analysisAddOrRMData(interfaceData.vacantHouseholdInfo[key]);
    }
    let 空置户数据DataAndUnit = objKeyReplace(空置户特化数据);
    ret["api1"] =  getKeyValue("空置户数据", 空置户数据DataAndUnit.dataMap, 空置户数据DataAndUnit.unitMap, false, false );

    let 住房空置率特化基础数据 = {};
    for (let key in housingInterface.housingVacancyRateInfo) {
        住房空置率特化基础数据[key] = analysisAddOrRMData(housingInterface.housingVacancyRateInfo[key]);
    }
    let 住房空置率数据DataAndUnit = objKeyReplace(住房空置率特化基础数据);
    ret["api2"] =  getKeyValue("住房空置率数据", 住房空置率数据DataAndUnit.dataMap, 住房空置率数据DataAndUnit.unitMap, false, false );

    let 空置用户电量特化基础数据 = {};
    for (let key in idleInterface.IdleUserPowerInfo) {
        空置用户电量特化基础数据[key] = analysisAddOrRMData(idleInterface.IdleUserPowerInfo[key]);
    }
    let 空置用户电量数据DataAndUnit = objKeyReplace(空置用户电量特化基础数据 );
    ret["api3"] =  getKeyValue("空置用户电量数据", 空置用户电量数据DataAndUnit.dataMap, 空置用户电量数据DataAndUnit.unitMap, false, false );

    ret["api4"] = getChartData("青浦区住房空置率趋势", interfaceData.qingPuDistrictHousing, '%', false );

    ret["api5"] = getMoreYChartData("重点区域住房空置率", interfaceData.housingVacancyInfo, false, {"用户数":"户","空置率":"%"});
    ret["api6"] = getMoreYChartData("典型小区住房空置率", rateInterface.residentialVacancyRateInfo, false, {"用户数":"户","空置率":"%"});
    ret["api7"] = getMoreYChartData("重点区域空置户趋势", areasInterface.vacantHouseholds, false, {"空置率趋势":"%"});
    ret["api8"] = getMoreYChartData("典型小区空置户趋势", trendsInterface.typicalResidential, false, {"空置率趋势":"%"});

    ret["apiarea"] = getKeyStringValue("范围数据", interfaceData.rangeInfo);
    res.send(ret);
}
    
