import { get智慧电眼_重点污染企业生产 } from "../../data/analysisExcelData";
import { getZdwrqysc } from "../../data/interface/zdwrqysc";
import { getChartData, getKeyValue, getListData, getSingleYAndMoreData, getMoreYChartData, objKeyReplace, analysisAddOrRMData, getKeyStringValue }from "../../util/tools";

    
export async function getData(req, res) {
    let ret:any = {};

    let interfaceData = await getZdwrqysc();

    let 污染企业数据dataAndUnit = objKeyReplace(interfaceData.pollutingInfo);
    ret["api1"] =  getKeyValue("污染企业数据", 污染企业数据dataAndUnit.dataMap, 污染企业数据dataAndUnit.unitMap, false, false );

    ret["api3"] = getMoreYChartData("各污染类型企业生产指数对比", interfaceData.pollutionTypeInfo, false, {"污染企业数":"户"})

    ret["api4"] = getMoreYChartData("各行业类型污染企业生产指数对比", interfaceData.industryTypeInfo, false, {"污染企业数":"户"})

    let 污染类型DataAndUnit = objKeyReplace(interfaceData.pollutingTypeInfo);
    ret["api5"] =  getKeyValue("污染类型", 污染类型DataAndUnit.dataMap, 污染类型DataAndUnit.unitMap, false, false );

    let 污染企业TOP10DataAndUnit = objKeyReplace(interfaceData.pollutingTop10);
    ret["api6"] =  getKeyValue("污染企业TOP10排名", 污染企业TOP10DataAndUnit.dataMap, 污染企业TOP10DataAndUnit.unitMap, false, false );


    let 污染企业生产数据DataAndUnit = objKeyReplace(interfaceData.productionInfo);
    ret["api7"] =  getKeyValue("污染企业生产数据", 污染企业生产数据DataAndUnit.dataMap, 污染企业生产数据DataAndUnit.unitMap, false, false );

    let 重点污染企业撒点数据DataAndUnit = interfaceData.pollutingCompaniesScatter;
    let pollutingCompaniesScatter = [];
    重点污染企业撒点数据DataAndUnit.forEach( item => {
        let {townName, latitudeAndLongitude, details} = item;
        let latitudeAndLongitudeList = [];
        latitudeAndLongitude.forEach( info => {
            let {latitude, longitude, elevation} = info;
            elevation = Math.floor(elevation * 100) / 100;
            latitudeAndLongitudeList.push({latitude, longitude, elevation:elevation});
        })
        let detailsnum = details.match(/\d+(\.\d+)?/g);
        let detailsstring = details.match(/[\u4e00-\u9fa5]/g);
        pollutingCompaniesScatter.push({townName, latitudeAndLongitude:latitudeAndLongitudeList, details});
    })
    
    ret["api8"] = {title: "重点污染企业撒点数据", dataList: pollutingCompaniesScatter};

    ret["apiarea"] = getKeyStringValue("范围数据", interfaceData.rangeInfo);
    
    res.send(ret);
}
    