import { get智慧电眼_疑似空壳企业监测 } from "../../data/analysisExcelData";
import { getYskkqyjc } from "../../data/interface/yskkqyjc";
import { getChartData, getKeyValue, getListData, getSingleYAndMoreData, getMoreYChartData, objKeyReplace, getKeyStringValue }from "../../util/tools";


export async function getData(req, res) {
    let ret:any = {};

    let interfaceData = await getYskkqyjc();

    let 基础数据DataAndUnit = objKeyReplace(interfaceData.basicInfo);
    ret["api1"] =  getKeyValue("基础数据", 基础数据DataAndUnit.dataMap, 基础数据DataAndUnit.unitMap, false, false );

    let 不同容量疑似空壳企业分布DataAndUnit = objKeyReplace(interfaceData.enterpriseDistribution);
    ret["api2"] =  getKeyValue("不同容量疑似空壳企业分布", 不同容量疑似空壳企业分布DataAndUnit.dataMap, 不同容量疑似空壳企业分布DataAndUnit.unitMap, false, false );


    let 非房地产 = {};
    let 房地产占比 = {"非房地产":0, "房地产":0};
    let 分离数据 = objKeyReplace(interfaceData.industrialInfo);
    for (let key in 分离数据.dataMap) {
        let value = 分离数据.dataMap[key];
        if (key != "房地产业") {
            非房地产[key] = `${value}${分离数据.unitMap[key] || '' }`;
            房地产占比["非房地产"] +=  value;
        } else {
            房地产占比["房地产"] += value;
        }
    }

    ret["api3"] = getChartData("非房地产", 非房地产, '户', false );

    ret["api4"] = getChartData("疑似空壳企业数变化趋势", interfaceData.changesNumberInfo, '户', false );

    ret["api5"] = getChartData("疑似空壳企业空壳率变化趋势", interfaceData.changesTrendShellInfo, '%', false );

    ret["api6"] = getKeyValue("行业疑似空壳企业分布", 房地产占比, "户", false, false);

    ret["apiarea"] = getKeyStringValue("范围数据", interfaceData.rangeInfo);
    
    res.send(ret);
}
