import { get智慧电眼_企业贷中信用评估 } from "../../data/analysisExcelData";
import { getindustryCredit, getQydzxypg } from "../../data/interface/qydzxypg";
import { getChartData, getKeyValue, getListData, getSingleYAndMoreData, getMoreYChartData, objKeyReplace, getKeyStringValue }from "../../util/tools";


export async function getData(req, res) {
    let ret:any = {};

    let interfaceData = await getQydzxypg();

    let 各信用等级企业分布情况DataAndUnit = objKeyReplace(interfaceData.distributionInfo);
    ret["api1"] =  getKeyValue("各信用等级企业分布情况", 各信用等级企业分布情况DataAndUnit.dataMap, 各信用等级企业分布情况DataAndUnit.unitMap, true, false );

    ret["api2"] = getSingleYAndMoreData("每月企业信用变化趋势", interfaceData.monthlyBusinessInfo, false, '户');

    let 行业信用分布对比Interface = await getindustryCredit();
    ret["api3"] = getSingleYAndMoreData("行业信用分布对比", 行业信用分布对比Interface.industryCreditInfo, false, '%');

    let 优质信用企业DataAndUnit = objKeyReplace(interfaceData.highQuality);
    ret["api4"] =  getKeyValue("优质信用企业", 优质信用企业DataAndUnit.dataMap, false, false, false );

    let 风险企业DataAndUnit = objKeyReplace(interfaceData.venture);
    ret["api5"] =  getKeyValue("风险企业", 风险企业DataAndUnit.dataMap, false, false, false );
    
    ret["apiarea"] = getKeyStringValue("范围数据", interfaceData.rangeInfo);

    res.send(ret);
}
