import { get智慧电眼_经济景气度 } from "../../data/analysisExcelData";
import { getJjjqd } from "../../data/interface/jjjcd";
import { getChartData, getKeyValue, getListData, getSingleYAndMoreData, getMoreYChartData, objKeyReplace, getKeyStringValue }from "../../util/tools";

    
export async function getData(req, res) {
    let ret:any = {};

    let interfaceData = await getJjjqd();

    let 基础数据DataAndUnit = objKeyReplace(interfaceData.basicInfo);
    ret["api1"] =  getKeyValue("基础数据", 基础数据DataAndUnit.dataMap, 基础数据DataAndUnit.unitMap, false, false );

    let 重点区域景气指数_青浦_DataAndUnit = objKeyReplace(interfaceData.prosperity);
    ret["api2"] =  getKeyValue("重点区域景气指数（青浦）", 重点区域景气指数_青浦_DataAndUnit.dataMap, 重点区域景气指数_青浦_DataAndUnit.unitMap, false, false );

    let 行业景气度DataAndUnit = objKeyReplace(interfaceData.industrialInfo);
    ret["api3"] =  getKeyValue("行业景气指数", 行业景气度DataAndUnit.dataMap, 行业景气度DataAndUnit.unitMap, false, false );

    ret["api4"] = getChartData("经济景气指数趋势分析", interfaceData.economicInfo, false, false );
    ret["api4"].yMinValue = 40;
    ret["api4"].yMaxValue = 160;
    ret["api4"].yStepValue = 40;

    ret["apiarea"] = getKeyStringValue("范围数据", interfaceData.rangeInfo);
    res.send(ret);
}
    