import { get智慧电眼_行业用电分布 } from "../../data/analysisExcelData";
import { getElectricity, getHyydfb } from "../../data/interface/hyydfb";
import { getChartData, getKeyValue, getListData, getSingleYAndMoreData, getMoreYChartData, objKeyReplace, getKeyStringValue }from "../../util/tools";

    
export async function getData(req, res) {
    let ret:any = {};

    let excelData:any = get智慧电眼_行业用电分布();
    let interfaceData = await getHyydfb();
    let electricityInterface = await getElectricity();

    let 基础数据DataAndUnit = objKeyReplace(interfaceData.basicInfo);
    ret["api1"] =  getKeyValue("基础数据", 基础数据DataAndUnit.dataMap, false, false, false );

    let 示范区行业用电分布DataAndUnit = objKeyReplace(electricityInterface.areaIndustryElectricity);
    ret["api2"] =  getKeyValue("示范区行业用电分布", 示范区行业用电分布DataAndUnit.dataMap, 示范区行业用电分布DataAndUnit.unitMap, true, false );

    ret["api3"] =  getSingleYAndMoreData("三地各行业用电量", interfaceData.electricityInfo, false, false);

    ret["api4"] = getSingleYAndMoreData("重点行业集中度年度分析（青浦）", interfaceData.concentrationAnalysis, false, false);
    ret["api4"].yMinValue = 40;
    ret["api4"].yMaxValue = 100;
    ret["api4"].yStepValue = 20;
    
    ret["apiarea"] = getKeyStringValue("范围数据", interfaceData.rangeInfo);
    res.send(ret);
}