import { get智慧电眼_规上企业生产运行状况 } from "../../data/analysisExcelData";
import { getGsqyscyx, getIndustrial } from "../../data/interface/gsqyscyx";
import { getChartData, getKeyValue, getListData, getSingleYAndMoreData, getMoreYChartData, objKeyReplace, getKeyStringValue }from "../../util/tools";

    
export async function getData(req, res) {
    let ret:any = {};

    let excelData:any = get智慧电眼_规上企业生产运行状况();
    let interfaceData = await getGsqyscyx();

    let 基础数据DataAndUnit = objKeyReplace(interfaceData.basicInfo);
    ret["api1"] =  getKeyValue("基础数据", 基础数据DataAndUnit.dataMap, 基础数据DataAndUnit.unitMap, false, false );

    let 行业生产指数Interface = await getIndustrial("行业生产指数");
    let 行业生产指数DataAndUnit = objKeyReplace(行业生产指数Interface.dataInfo);
    ret["api2"] =  getKeyValue("行业生产指数", 行业生产指数DataAndUnit.dataMap, 行业生产指数DataAndUnit.unitMap, false, false );

    let 规上企业行业分布概览Interface = await getIndustrial("规上企业行业分布概览");
    let 规上企业行业分布概览DataAndUnit = objKeyReplace(规上企业行业分布概览Interface.dataInfo);
    ret["api3"] =  getKeyValue("规上企业行业分布概览", 规上企业行业分布概览DataAndUnit.dataMap, 规上企业行业分布概览DataAndUnit.unitMap, true, false );

    ret["api4"] = getChartData("生产指数趋势分析", interfaceData.productionInfo, false, false );
    ret["api4"].yMinValue = 40;
    ret["api4"].yMaxValue = 160;
    ret["api4"].yStepValue = 40;

    ret["apiarea"] = getKeyStringValue("范围数据", interfaceData.rangeInfo);
    res.send(ret);
}
    