import { get智慧电眼_城市群协同发展 } from "../../data/analysisExcelData";
import { getArea, getCsqxtfz } from "../../data/interface/csqxtfz";
import { getChartData, getKeyValue, getListData, getSingleYAndMoreData, getMoreYChartData, objKeyReplace, getKeyStringValue }from "../../util/tools";

export async function getData(req, res) {
    let ret:any = {};

    let excelData:any = get智慧电眼_城市群协同发展();
    let interfaceData = await getCsqxtfz();

    let 基础数据DataAndUnit = objKeyReplace(interfaceData.basicInfo);
    ret["api1"] =  getKeyValue("基础数据", 基础数据DataAndUnit.dataMap, false, false, false );

    let 吴江区数据Interface = await getArea("吴江");
    let 吴江区数据DataAndUnit = objKeyReplace(吴江区数据Interface.dataInfo);
    ret["api2"] =  getKeyValue("吴江区数据", 吴江区数据DataAndUnit.dataMap, 吴江区数据DataAndUnit.unitMap, false, false );

    ret["api3"] = getChartData("长三角示范区一体化协同发展指数趋势",interfaceData.demonstrationInfo, false, false);
    ret["api3"].yMaxValue = 150;
    ret["api3"].yStepValue = 5;
    ret["api3"].yMinValue = 80;  

    let 青浦区数据Interface = await getArea("青浦");
    let 青浦区数据DataAndUnit = objKeyReplace(青浦区数据Interface.dataInfo);
    ret["api4"] =  getKeyValue("青浦区数据", 青浦区数据DataAndUnit.dataMap, 青浦区数据DataAndUnit.unitMap, false, false );

    let 嘉善县数据Interface = await getArea("嘉善");
    let 嘉善县数据DataAndUnit = objKeyReplace(嘉善县数据Interface.dataInfo);
    ret["api5"] =  getKeyValue("嘉善县数据", 嘉善县数据DataAndUnit.dataMap, 嘉善县数据DataAndUnit.unitMap, false, false );
    
    ret["apiarea"] = getKeyStringValue("范围数据", interfaceData.rangeInfo);
    res.send(ret);
}
    