import { getChartData, getKeyValue, getListData, getSingleYAndMoreData, getMoreYChartData, objKeyReplace }from "../../util/tools";
import { getQyrh } from "../../data/interface/qyrh";
import { get区域融合 } from "../../data/analysisExcelData";

export async function getData(req, res) {
    let ret:any = {};

    let excelData:any = get区域融合();
    let interfaceData = await getQyrh();

    ret["api19"] = getListData("值班管理", interfaceData.dutyManagement, ["名称", "是否到岗"] , {"名称":"name", "是否到岗":"required"});

    let _码上办_实时监测DataAndUnit = objKeyReplace(interfaceData.realTimeMonitoringInfo);
    ret["api31"] =  getKeyValue("“码上办”实时监测", _码上办_实时监测DataAndUnit.dataMap, _码上办_实时监测DataAndUnit.unitMap, true, false );

    let _码上办_监测结果DataAndUnit = objKeyReplace(interfaceData.monitoringResultsInfo);
    ret["api32"] =  getChartData("“码上办”监测结果", _码上办_监测结果DataAndUnit.dataMap, "户", false );

    ret["api28"] = 特化营商环境("营商环境", "青浦区", excelData.供电可靠性_青浦区, interfaceData.easeOfDoingInfo, interfaceData.timelinessInfo, interfaceData.interactivityInfo);

    ret["api23"] = getListData("检修计划",interfaceData.schedulingLogOverhaulSchedule, ["序号","区域","工作内容","日期"],{"序号":"serialNumber","区域":"area","工作内容":"jobContent","日期":"dateTime"});
    ret["api24"] = getListData("故障抢修",interfaceData.schedulingLogTroubleshooting, ["序号","区域","工作内容","日期"],{"序号":"serialNumber","区域":"area","工作内容":"jobContent","日期":"dateTime"});
    ret["api25"] = getListData("停电停役",interfaceData.schedulingLogPowerOutage, ["序号","区域","工作内容","日期"],{"序号":"serialNumber","区域":"area","工作内容":"jobContent","日期":"dateTime"});
    ret["api26"] = getListData("设备缺陷",interfaceData.schedulingLogDeviceDefect, ["序号","区域","工作内容","日期"],{"序号":"serialNumber","区域":"area","工作内容":"jobContent","日期":"dateTime"});
    ret["api27"] = getListData("事故异常",interfaceData.schedulingLogAccidentException, ["序号","区域","工作内容","日期"],{"序号":"serialNumber","区域":"area","工作内容":"jobContent","日期":"dateTime"});

    //excel-----------------------------
    let 一体化电网运行管理DataAndUnit = objKeyReplace(excelData.一体化电网运行管理);
    ret["api3"] = getKeyValue("一体化电网运行管理", 一体化电网运行管理DataAndUnit.dataMap, 一体化电网运行管理DataAndUnit.unitMap, true, false );
    ret["api3"].list.forEach(info => {
        info.value = 特化一体化电网运行管理(info.value);
    });

    ret["api4"] = getListData("工程进度",excelData.工程进度,["工程名称","开始时间","预计完成时间","工程进度"],{"工程名称":"name","开始时间":"startTime","预计完成时间":"endTime","工程进度":"rate"});

    ret["api6"] = getSingleYAndMoreData("电网作业风险事件", excelData.电网作业风险事件, false, 'false');

    let 一体化新型电力系统DataAndUnit = objKeyReplace(excelData.一体化新型电力系统);
    ret["api7"] =  getKeyValue("一体化新型电力系统", 一体化新型电力系统DataAndUnit.dataMap, 一体化新型电力系统DataAndUnit.unitMap, false, false );
    
    let 嘉善县DataAndUnit = objKeyReplace(excelData.嘉善县);
    ret["api16"] =  getKeyValue("嘉善县",  嘉善县DataAndUnit.dataMap,  嘉善县DataAndUnit.unitMap, false, false );
    let 吴江区DataAndUnit = objKeyReplace(excelData.吴江区);
    ret["api17"] =  getKeyValue("吴江区",  吴江区DataAndUnit.dataMap,  吴江区DataAndUnit.unitMap, false, false );
    let 青浦区DataAndUnit = objKeyReplace(excelData.青浦区);
    ret["api18"] =  getKeyValue("青浦区",  青浦区DataAndUnit.dataMap,  青浦区DataAndUnit.unitMap, false, false );
    let 地图链接数据 = { 
        title: "地图链接",
        subTitle : "地图链接",
        total : 0,
        list : []
    };
    for (let key in excelData.地图链接) {
        地图链接数据.list.push({"key":key, "value": excelData.地图链接[key] });
    }
    ret["api20"] = 地图链接数据;

    ret["api22"] = { title:"图片", data:{
        "img1":"img/qyrh1.png",
        "img2":"img/qyrh2.gif"
    } };
    ret["api29"] = 特化营商环境("营商环境", "嘉善县", excelData.供电可靠性_嘉善县, excelData.营商业务便利性_嘉善县, excelData.营商业务及时性_嘉善县, excelData.营商业务互动性_嘉善县);
    ret["api30"] = 特化营商环境("营商环境", "吴江区", excelData.供电可靠性_吴江区, excelData.营商业务便利性_吴江区, excelData.营商业务及时性_吴江区, excelData.营商业务互动性_吴江区);
    
    let _码上办_政策提示DataAndUnit = objKeyReplace(excelData._码上办_政策提示);
    ret["api33"] =  getKeyValue("“码上办”政策提示", _码上办_政策提示DataAndUnit.dataMap, _码上办_政策提示DataAndUnit.unitMap, false, false );

    res.send(ret);
}

function 特化一体化电网运行管理(number) {
    let checkData = new Date().valueOf() - new Date('2021-10-25 00:00:00').valueOf();
    return Math.floor(checkData / (3600 * 1000 * 24)) + number;
}

function 特化营商环境(title, subTitle, 供电可靠性, 营商业务便利性, 营商业务及时性, 营商业务互动性) {
    let data:any = {title, subTitle, dataList:[] };

    let 营商业务便利性DataAndUnit = objKeyReplace(营商业务便利性);
    let ysywblxData = {title:"营商业务便利性", data:[]};
    for (let key in 营商业务便利性DataAndUnit.dataMap) {
        
        ysywblxData.data.push({
            key,
            value:营商业务便利性DataAndUnit.dataMap[key],
            unit:营商业务便利性DataAndUnit.unitMap[key]
        });
    }
    data.dataList.push(ysywblxData);



    let 供电可靠性DataAndUnit = objKeyReplace(供电可靠性);
    let gdkkxData = {title:"供电可靠性", data:[]};
    for (let key in 供电可靠性DataAndUnit.dataMap) {
        
        gdkkxData.data.push({
            key,
            value:供电可靠性DataAndUnit.dataMap[key],
            unit:供电可靠性DataAndUnit.unitMap[key]
        });
    }
    data.dataList.push(gdkkxData);

    let 营商业务及时性DataAndUnit = objKeyReplace(营商业务及时性);
    let ysywjsxData = {title:"营商业务及时性", data:[]};
    for (let key in 营商业务及时性DataAndUnit.dataMap) {
        
        ysywjsxData.data.push({
            key,
            value:营商业务及时性DataAndUnit.dataMap[key],
            unit:营商业务及时性DataAndUnit.unitMap[key]
        });
    }
    data.dataList.push(ysywjsxData);

    let ysywhdx = {title:"营商业务互动性", data:[]};
    for (let key in  营商业务互动性) {
        ysywhdx.data.push({key, value:""});
    }
    data.dataList.push(ysywhdx);

    return data;
}
