import { get绿色电力_充电设施发展监控 } from "../../data/analysisExcelData";
import { getCdssfzjk } from "../../data/interface/cdssfzjk";
import { analysisAddOrRMData, getChartData, getDataMapDecimalForN, getDecimalForN, getDropMoreData, getKeyValue, getMoreYChartData, objKeyReplace } from "../../util/tools";

export async function getData(req, res) {
    let ret:any = {};
    let excelData:any = get绿色电力_充电设施发展监控();
    let interfaceData = await getCdssfzjk();
        
    let 充电设施发展监控DataAndUnit = objKeyReplace(interfaceData.chargingInfo);
    ret["api6"] =  getKeyValue("充电设施发展监控", 充电设施发展监控DataAndUnit.dataMap, 充电设施发展监控DataAndUnit.unitMap, false, false );
        
    let 服务车次DataAndUnit = objKeyReplace(interfaceData.realTimeMonitoringInfo);
    
    ret["api7"] =  getKeyValue("服务车次", 服务车次DataAndUnit.dataMap,服务车次DataAndUnit.unitMap , false, false );
    
    ret["api8"] = getChartData("每月服务车次", interfaceData.monthInfo, '次', false);

    //excel---------------------------------
    let 特化数据 = {};
    for (let key in excelData.当期绿电指数) {
        特化数据[key] = analysisAddOrRMData(excelData.当期绿电指数[key]);
    }
    let 当期绿电指数DataAndUnit = objKeyReplace(特化数据);
    ret["api1"] =  getKeyValue("当期绿电指数", 当期绿电指数DataAndUnit.dataMap, 当期绿电指数DataAndUnit.unitMap, false, false );
    
    ret["api2"] = getMoreYChartData("同比趋势分析", checkNumber(excelData.同比趋势分析), false, {"绿电指数":"","同比增长":"%"})

    ret["api3"] = getMoreYChartData("环比趋势分析", checkNumber(excelData.环比趋势分析), false, {"绿电指数":"","环比增长":"%"})

    let 绿电指数折线图保留小数数据 = getDataMapDecimalForN(excelData.绿电指数折线图);
    ret["api5"] = getChartData("绿电指数折线图", 绿电指数折线图保留小数数据, false, false );
    ret["api5"].yMinValue = 100;

    ret["api14"] = getDropMoreData(excelData.绿电指数与经济指数相关分析_2017_2020_, "绿电指数与经济指数相关分析（2017-2020）", "绿电指数与经济指数相关分析（2017-2020）");
    ret["api15"] = getDropMoreData(excelData.上海市空气质量AQI优良率, "绿电指数与环境指数相关分析（2017-2020）", "上海市空气质量AQI优良率");
    ret["api16"] = getDropMoreData(excelData.青浦区PM2_5月均浓度, "绿电指数与环境指数相关分析（2017-2020）", "青浦区PM2.5月均浓度");

    ret["api17"] = getDropMoreData(excelData.绿电指数与经济指数相关分析均值, "绿电指数与经济指数相关分析均值", "绿电指数与经济指数相关分析均值");
    ret["api18"] = getDropMoreData(excelData.上海市空气质量AQI优良率均值, "上海市空气质量AQI优良率均值", "上海市空气质量AQI优良率均值");
    ret["api19"] = getDropMoreData(excelData.青浦区PM2_5月均浓度均值, "青浦区PM2.5月均浓度均值", "青浦区PM2.5月均浓度均值");    
    
    res.send(ret);
}

//特化  小数保留两位
function checkNumber(data) {
    let result = {};

    for (let key in data) {
        result[key] = {};
        let info = data[key];
        for (let subKey in info) {
            let value = info[subKey] ? getDecimalForN(parseFloat(info[subKey]), 2) : 0;
            result[key][subKey] = value;
        }
    }

    return result;
}