

export function limitEnteNameString(name, number?) {
    number = number ? number : 13;
    if (name.length > number) return `${name.substring(0,number - 2)}...`;
    return name;
}

const moneyStrConfig = {
    "万亿": 13,
    "萬億": 13, 
    "千亿": 12, 
    "千億": 12, 
    "百亿": 11, 
    "佰億": 11, 
    "十亿": 10, 
    "拾億": 10, 
    "亿": 9, 
    "億": 9, 
    "千万": 8, 
    "千萬": 8, 
    "百万": 7, 
    "佰萬": 7,
    "十万": 6, 
    "拾萬": 6, 
    "万": 5, 
    "萬": 5,
    "千":4,
    "百":3,
    "十":2,
    "美元":1,
    "人名币":1,
    "元":1,
};
// 汇率
let dollarRate = 6.4731;
//解析金额
export function analysisMoneyStr(mnyStr:string) {
    let zeroNum = 1;
    let moneyNumber = 0;
    for (let key in moneyStrConfig) {
        let checkNum = mnyStr.indexOf(key);
        if (checkNum > -1) {
            zeroNum = moneyStrConfig[key];
            moneyNumber = parseFloat(mnyStr.slice(0, checkNum));
            break;
        }
    }
    if (mnyStr.replace(/[^0-9]/ig,"") == "") return 0;


    if (zeroNum > 1) { 
        let count = 1;
        for (let i = 1; i < zeroNum; i++) {
            count = count * 10;
        }
        zeroNum = count;
    }

    let money = parseInt(`${zeroNum * moneyNumber}`);

    if (mnyStr.indexOf('美元')) money = parseInt(`${money * dollarRate}`);

    return money;
}


//缩略金额
export function simplifyMoney(mny:number, str:string) {
    let num = moneyStrConfig[str];

    let count = 1;

    for (let i = 1; i < num; i++) {
        count = count * 10;
    }

    return mny / count;
}

//分离 带单位的数据
function separateDataAndUint(str) {
    if (!str) return {data:0, unit:""};
    let data = str.replace(/[\u4E00-\u9FA5a-zA-Z]+/,"");
    let unit = str.replace(/^(-)?\d+(\.\d+)?/, "");
    return {data, unit};
}

//object key替换 带单位
export function objKeyReplace(object, keyInfo = {}, isString = true) {
    if (isString) {
        //校验字符
        for (let key in object) {
            if (!object[key]) object[key] = '';
        }
    } else {
         //校验数字
         for (let key in object) {
            if (!object[key]) object[key] = '0';
        }
    }
    let unitMap = {};
    let dataMap = {};
    for(let key in object) {
        let newKey = keyInfo[key] || key;
        let {data, unit} = separateDataAndUint(`${object[key]}` || "");
        unitMap[newKey] = unit;
        dataMap[newKey] =  parseFloat(data);
    }
    return {dataMap, unitMap};
}

//返回特定key和value的obj
export function objKeyAndValue(dataMap, ...keyList) {
    let result = {};
    for (let key in dataMap) {
        if ( keyList.indexOf(key) > -1 ) result[key] = dataMap[key];  
    }
    return result;
}

//获取键值数据  percent =>为数字的时候 保留几位小数
export function getKeyValue(title, dataMap, unit, total, percent ) {
    let data = { 
        title, 
        subTitle : title,
        total : 0,
        list : []
    };
    let count = 0;
    for (let key in dataMap) {
        let value = parseFloat(dataMap[key]);
        count += value;
        if (total) data.total += value;
    }
    for (let key in dataMap) {
        let thisUnit = "";
        if (unit) {
            if (typeof unit == "string") thisUnit = unit;
            else thisUnit = unit[key];
        }
        let value = parseFloat(dataMap[key]);
        if (percent) {
            thisUnit = '%';
            value = getDecimalForN( value/count, percent);
        }
        let onceInfo:any = { key, value, unit:thisUnit };
        data.list.push(onceInfo);
    }
    return data;
}
export function getChartData(title, dataMap, unit, percent ) {
    unit = unit || "";
    let data = {
        title, yMaxValue:0, yMinValue:new Date().valueOf(), yStepValue:0, unit : percent ? "%" : unit ,
        data: { title: title , total : 0, list : [ ] }
    }
    let count = 0;
    
    for (let key in dataMap) {
        let value = parseFloat(dataMap[key]);
        data.yMaxValue = Math.max(data.yMaxValue, value);
        data.yMinValue = Math.min(data.yMinValue, value);
        count += value;
        data.data.total += value;
    }
    data.yStepValue = Math.ceil(data.yMaxValue - data.yMinValue / count);
    
    for (let key in dataMap) {
        let value = parseFloat(dataMap[key]);
        let thisUnit = unit;
        if (percent) {
            thisUnit = '%';
            value = getDecimalForN( value/count, percent);
        }
        let onceInfo = { key, unit:thisUnit, value };
        data.data.list.push(onceInfo)
    }

    return data;
}

export function getListData( title, dataList, titleList, titleValueObj ) {
    let data = { title, subTitle:title, total:dataList.length, titleList, valueList:[] };

    dataList.forEach(info => {
        let onceList = [];
        titleList.forEach(titleName => {
            onceList.push(info[ titleValueObj[titleName] ]);
        });
        data.valueList.push(onceList);
    });
   return data;
}

//多个y轴的条柱状图  dataMap => {"name":{"key1":1111,"key2":232, "key3":dsfs, ... }, ... }
export function getMoreYChartData(title, dataMap, percent, unit ) {
    let data = { title, dataList: [] };

    for (let subDataName in dataMap) {
        let onceData =  { title:subDataName, yMaxValue:0, yMinValue:new Date().valueOf(), yStepValue:0, unit:"", total : 0, list : [ ] };

        let thisDataInfo = dataMap[subDataName];

        for (let key in thisDataInfo) {
            let value = parseFloat(thisDataInfo[key]);
            onceData.yMaxValue = Math.max(onceData.yMaxValue, value);
            onceData.yMinValue = Math.min(onceData.yMinValue, value);
            onceData.total += value;
        }

        onceData.yStepValue = Math.ceil(onceData.yMaxValue - onceData.yMinValue / onceData.total);

        let thisUnit;
        if (percent) {
            thisUnit = "%";
            onceData.yMaxValue = 100;
            onceData.yStepValue = Math.ceil(100 - onceData.yMinValue / onceData.total);
        }
        else if (typeof unit == 'object') {
            thisUnit = unit[subDataName] || "";
        } else thisUnit = unit || "";

        for (let key in thisDataInfo) {
            let value;
            if (percent) value = getDecimalForN( value/onceData.total, percent);
            else value = parseFloat(thisDataInfo[key]);
            let onceInfo = { key, unit:thisUnit, value };
            onceData.list.push(onceInfo)
        }
        data.dataList.push(onceData);
    }

    return data;
}

//一个y轴的多个数据的柱状图
export function getSingleYAndMoreData(title, dataMap, percent, unit) {
    let data = { title, dataList:[], yMaxValue:0, yMinValue:new Date().valueOf(), yStepValue:0, unit:"", total : 0 };

    for (let subDataName in dataMap) {
        let onceData =  { title:subDataName, list:[] };
        let thisDataCount = 0;

        for (let key in dataMap) {
            let value = parseFloat(dataMap[key]);
            thisDataCount += value;
        }

        let thisUnit;
        if (percent) thisUnit = "%";
        else if (typeof unit == 'object') {
            thisUnit = unit[subDataName] || "";
        } else thisUnit = unit || "";

        for (let key in dataMap) {
            let value;
            if (percent) value = getDecimalForN( value/thisDataCount, percent);
            else value = parseFloat(dataMap[key]);

            data.yMaxValue = Math.max(data.yMaxValue, value);
            data.yMinValue = Math.min(data.yMinValue, value);
            data.total += value;

            let onceInfo = { key, unit:thisUnit, value };
            onceData.list.push(onceInfo)
        }
        data.dataList.push(onceData);
    }

    data.yStepValue = Math.ceil(data.yMaxValue - data.yMinValue / data.total);

    return data;
}

//按需取保留小数长度 tenNumber保留小数位 1位就填1
export function getDecimalForN(number, n) {
    let ten = 1;

    for (let i = 0; i < n; i ++) {
        ten = ten * 10;
    }

    return Math.ceil(number * ten) / ten
}

//生日获取时间段
export function getAgeByBirthday(birthday:string) {
    let b = new Date(birthday).valueOf();
    let d = new Date().valueOf();

    let onceYear = 365 * 24 * 3600 * 1000;

    let age = Math.floor( (d - b) / onceYear );

    if (age >= 21 && age <= 30 ) return "21-30";
    else if (age >= 31 && age <= 40 ) return "35-45";
    else if (age >= 41 && age <= 50 ) return "46-55";
    else if (age > 50) return "50岁以上";
    else return '其他';
}

export function analysisAddOrRMData(str) {
    let checkStr = str.replace(/增加/, "+");
    let result = checkStr.replace(/减少/, "-");
    return result;
}