//新的解析
const fs = require('fs');
const xlsx = require('node-xlsx');
const path = require('path');

/**
 *   getExcelDataBySheetName 将excel文件解析成数据块数据
 * @param fileName 文件名称
 * @param sheetName 表名称
 * @returns thisBlockData 返回数据块集合 格式：blockList = [ {blockData:数据块(二维数组), blockTitle:"数据标题"}]
 */

export function getExcelDataBySheetName(fileName, sheetName) {
    let {sheetMap, sheetList} = getExcel(`${__dirname.substring(0,__dirname.indexOf("out"))}res\\${fileName}`);
    let thisBlockData = getBlockData(sheetMap[sheetName]);
    return thisBlockData;
}

/**
 *  getBlockDataByData  将excel解析出来的二维数组解析成数据块模式
 * @param dataList excel解出来的数据
 * @returns thisBlockData 返回数据块集合 格式：blockList = [ {blockData:数据块(二维数组), blockTitle:"数据标题"}]
 */
export function getBlockDataByData(dataList) {
    let thisBlockData = getBlockData(dataList);
    return thisBlockData;
}

/**
 * analysisExcelDataOfObject  将excel解出来的数据块按需求解析成可用数据
 * @param dataList excel解出来的数据
 * @param isJumpTitle 是否跳过解析表头
 * @param keyInX 表头是否是横向排列
 * @returns 返回 {"数据标题":数据对象 }
 */
export function analysisExcelDataOfObject(dataList, isJumpTitle?, keyInX?) {
    let result = {};
    if (keyInX) {
        let keyList = dataList[0];
        let valueList = dataList[1];
        let i = isJumpTitle ? 1:0;
        for (; i < keyList; i++) {
            let key = keyList[i];
            let value = valueList[i] || null;
            result[key] = value;
        }
    } else {
        let y = isJumpTitle ? 1: 0;
        for (; y < dataList.length; y++) {
            let childList = dataList[y];
            let key = childList[0];
            let value = childList[1] || null;
            result[key] = value;
        }
    }
    return result;
}

export function testmain() {
    
    let {sheetMap, sheetList} = getExcel(`${__dirname.substring(0,__dirname.indexOf("out"))}res\\数据模板.xlsx`);
    //根据配置表解析成对应数据
    let resultMap = {};
    for (let sheetName in sheetMap) {
        let thisSheetBlockList = getBlockData(sheetMap[sheetName]);
        resultMap[sheetName] = thisSheetBlockList;
    }
    console.log(resultMap);
    return resultMap;
}

/**
 * getBlockData 数据分块 
 * @param dataList  解析出来的excel二维数组
 * @returns 返回数据块集合 格式：blockList = [ {blockData:数据块(二维数组), blockTitle:"数据标题"}]
 */
function getBlockData(dataList) {
    let blockList = [];
    for (let i = 0; i < 999; i++) {
        let {blockData, blockTitle, notItem, delDataList} = checkBlock(dataList);
        if (notItem) break;
        dataList = delDataList;
        if (blockTitle) blockList.push({blockData, blockTitle});
    }
    return blockList;
}

function getListFristNotNullItemIndex(list) { //获取起始坐标
    if (!list.length) return null;
    for (let i = 0; i < list.length; i++) {
        if (list[i]) return i;
    }
}
function getListFirstNullItemIndex(list) { //获取第一个为空的坐标
    if (!list.length) return null;
    let checkItem = false;
    let firstItemIndex = 0;
    for (let i = 0; i <= list.length; i++) {
        let item = list[i];
        if (!checkItem && item) checkItem = true;
        
        if (checkItem && !item) {
            firstItemIndex = i;
            break;
        }
    }
    return firstItemIndex;
}
function listRegionIsNull(list, startX, endX) { //指定区间内数据是否未空
    let isNull = true;
    if ( !list.length ) return isNull;

    for (let i = startX; i < endX; i++) {
        let item = list[i];
        if (item) {
            isNull = false;
            break;
        }
    }
    return isNull;
}

function thisListNotItem(list) {
    for (let i = 0; i < list.length; i++) {
        if (list[i]) return false;
    }
    return true
}

function checkBlock(dataList) {
    //纵向有效起始点
    let startY = 0;
    let startX = 0;
    let isNotBlockTitle = false; //没有块标题
    let isLook = false;
    let endX = 0;//x轴最长结束下标 【包括下标】
    

    let blockTitle = ''; //标题块名称

    let notItem = true;

    for (let i = 0; i < dataList.length; i++) {
        let childList = dataList[i] || [];

        if (!thisListNotItem(childList)) {
            
            if ( !isLook ) {
                let thisRoowStartX = getListFristNotNullItemIndex(childList);
                let thisRoowLastItem = childList[thisRoowStartX + 1];
                let LastList = dataList[i+1] || [];
                let lastRoowStartX = getListFristNotNullItemIndex(LastList);
                
                if ( thisRoowLastItem || (LastList.length && lastRoowStartX == thisRoowStartX)  ) {
                    
                    if (lastRoowStartX == thisRoowStartX && thisRoowLastItem ) {
                        isNotBlockTitle = true; //不存在标题块
                        blockTitle = `${thisRoowStartX}_${i}`;
                        startY = i;
                        startX = thisRoowStartX;
                    }
                    else {
                        blockTitle = dataList[i][thisRoowStartX];
                        dataList[i][thisRoowStartX] = null;

                        if ( thisRoowLastItem ) { // 同行存在元素 标题在y轴上
                            startY = i;
                            startX = thisRoowStartX + 1;
                        } else {  // 同行存在元素 标题在x轴上
                            startY = i + 1;
                            startX = thisRoowStartX;
                        }
                    }
                    
                    isLook = true;
                } else { //只有标题 无内容
                    console.log(dataList[i][thisRoowStartX]);
                    dataList[i][thisRoowStartX] = null;
                }
                
            } else {
                //测量最大连续长度
                let firstNullX = getListFirstNullItemIndex(childList);
                if (firstNullX) endX = Math.max(endX, firstNullX-1);
                break;
            }
            notItem = false;
        }
    }
    let endY = 0;//y轴连续下标 【包括下标】

    let yInfoStart = false;
    let yInfoEnd = false;

    for (let y = startY; y < dataList.length; y++) {
        //纵向找连续性
        let thisRoow = dataList[y];
        let regionIsNull = listRegionIsNull(thisRoow, startX, endX);
        if (!regionIsNull) {
            endY = y;
            if (!yInfoStart) yInfoStart = true;
        }
        if (yInfoStart && regionIsNull) yInfoEnd = true;
        if (yInfoEnd) break;
    }
    
    let blockData = [];
    for (let y = startY; y <= endY; y++) {
        let onceList = [];
        for (let x = startX; x <= endX; x++) {
            onceList.push(dataList[y][x]);
            dataList[y][x] = null;
        }
        blockData.push(onceList);
    }

    return {blockData, blockTitle, delDataList:dataList,notItem};
}



//获取单个excel文件的数据
function getExcel(filePath) {
    const workSheetsFromFile = xlsx.parse(filePath);
    let sheetMap = {};
    let sheetList = [];

    for (let i = 0; i < workSheetsFromFile.length; i++) {
        let sheetInfo = workSheetsFromFile[i];
        sheetMap[sheetInfo.name] = sheetInfo.data;
        sheetList.push(sheetInfo);
    }

    return {sheetMap, sheetList}  
}