let fs = require('fs');
const { title } = require('process');
//excel的名字
const excelName = "数据模板";

let typeEnum = {
    "键值数据" : 1,
    "图标数据" : 2,
    "列表数据" : 3
}


const createBizAndDataConfigMap = {
    "page1": {
        sheetName:"页面1", 
        apiList:[
            { type:"键值数据", dataName:"模拟数据块", title:"教师学段人数", unit:"个", total:true, percent:false},
            { type:"键值数据", dataName:"模拟数据块2", title:"教师学段人数2", unit:"个", total:true, percent:false},
            { type:"柱状数据", dataName:"模拟数据块3", title:"教师学段人数", unit:"个", total:true, percent:false,subTitle:"111"},
            { type:"键值数据", dataName:"模拟数据块4", title:"教师学段人数", unit:"个", total:true, percent:false}
        ]
    },
    "page2": {
        sheetName:"页面2", 
        apiList:[
            {}
        ]
    },
    "page3": {
        sheetName:"页面3", 
        apiList:[
            {}
        ]
    }
};


//创建data层
function createData() {
    let str = `
    import * as path from "path";
    import * as fs from "fs";
    import { BizError } from "../util/bizError";
    import { limitEnteNameString } from "../util/tools";
    import { getExcelDataBySheetName, analysisExcelDataOfObject } from "../util/analysisExcel";`;



    for (let pangeName in createBizAndDataConfigMap) {
        let { sheetName } = createBizAndDataConfigMap[pangeName];

    str += `

    export function get${sheetName}() {;
        let bolckDataList = getExcelDataBySheetName('${excelName}', '${sheetName}');
        let result = {};
        for (let i = 0; i < bolckDataList.length; i++) {
            let {blockData, blockTitle} = bolckDataList[i];
            let analysisData = analysisExcelDataOfObject(blockData, true, true);
            result[blockTitle] = analysisData;
        }
        
        return result;
    }`;
    }

    let path = `./data/analysisExcelData.ts`;
    fs.access(path, (err) => {
        if (!err) {
            console.error(path, "文件已存在");
            return;
        }
        
        fs.writeFileSync(path,  str);
        console.log(path, "创建文件成功")
    });
}

//创建biz层
function createBiz(){
    for (let pageName in createBizAndDataConfigMap) {
        let { apiList, sheetName } = createBizAndDataConfigMap[pageName];

        let thisBizData = getBizStr(apiList, sheetName);

        let path = `./biz/${pageName}.ts`;
        fs.access(path, (err) => {
            if (!err) {
                console.error(path, "文件已存在");
                return;
            }
            
            fs.writeFileSync(path,  thisBizData);
            console.log(path, "创建文件成功")
        });

    }
}


function getBizStr(apiList, sheetName) {
    let str = `
    import { getChartData, getKeyValue, limitEnteNameString, objKeyAndValue, objKeyReplace }from "../util/tools";
    import { get${sheetName} } from "../data/analysisExcelData";
    `;
    str += `
    export function getData(req, res) {
        let ret:any = {};

        let excelData:any = get${sheetName}();
    `;
    apiList.forEach((info, index) => {
        let  {dataName, unit, total, percent, type} = info;
        const apiName = `api${index+1}`;

        let subStr = `
        ret["${apiName}"] = `;

        switch(type) {
            case "键值数据": subStr += `getKeyValue("${dataName}", excelData.${dataName},'${unit}', ${total}, ${percent} )`; break;
            case "柱状数据": subStr += `getChartData(excelData.${dataName}, '${unit}', ${percent} )`; break;
            case "列表数据": subStr += `getKeyValue("${dataName}")`; break;
        };

        str+=
    `${subStr}
    `

    });
   
    
    str += `
        res.send(ret);
    }
    `
    return str;
}

//创建Router层
function createRouter() {
    let importName="";
    let routergetName="";
    let routerpostName="";

    apiList.forEach(apiInfo => {
        importName+=`
        import * as ${apiInfo.name}Biz from '../biz/${apiInfo.name}';
        `

        routergetName+=`
        httpServer.get('/${apiInfo.name}', asyncHandler(${apiInfo.name}Biz.getData));
        `
        routerpostName+=`
        httpServer.post('/${apiInfo.name}', asyncHandler(${apiInfo.name}Biz.getData));
        `
    });

    let str=`
        import * as asyncHandler from 'express-async-handler'
        ${importName}

        export function srtRouter(httpServer){
            ${routergetName}
            ${routerpostName}
        }`
    let path = `./routers/router.ts`;
    fs.access(path, (err) => {
        if (!err) {
            console.error(path, "文件已存在");
            return;
        }
        
        fs.writeFileSync(path, str);
        console.log(path, "创建router文件成功")
    });
}


createData();
//createRouter();
createBiz();

//创建 biz层



