
import { mySqlConfig } from '../../serverConfig';
import { createMySqlConnect} from './mysql_connect';

let mysql_ddptDB;

export function initMysqlDB() {
    const dataBase = 'ddpt';

    mysql_ddptDB = createMySqlConnect(mySqlConfig.mysqlHost, mySqlConfig.mysqlPort, mySqlConfig.mysqlUser, mySqlConfig.mysqlPwd, dataBase);
    mysql_ddptDB.connect(handleError);
    mysql_ddptDB.on('error', handleError);
}
function handleError (err) {
    if (err) {
      // 如果是连接断开，自动重新连接
      if (err.code === 'PROTOCOL_CONNECTION_LOST') {
        initMysqlDB();
      } else {
        console.error(err.stack || err);
      }
    }
  }

export { mysql_ddptDB };