import mongoose = require('mongoose');
import mongoClient = require('mongodb');

let defaultOptions = {
  // useNewUrlParser:true,
  auto_reconnect:true,
  reconnectTries:1000,
  reconnectInterval:3000,
  keepAlive: 1,
  connectTimeoutMS: 30000
};


export async function createDbConnect(connectUrl:string, options?:object) {
    if (!connectUrl) throw new Error(`wrong connect url ${connectUrl}`);
    if (!options) options = defaultOptions;
    console.log("connection mongo=> ",connectUrl);
    return await mongoose.createConnection(connectUrl, options).catch((err)=>{throw err});
}
