
    import * as path from "path";
    import * as fs from "fs";
    import { BizError } from "../util/bizError";
    import { limitEnteNameString, changeDataName } from "../util/tools";
    import { getExcelDataBySheetName, analysisExcelDataOfObject, analysisExcelDataOfMoreObject, analysisExcelDataOfList, analysisExcelDataOfStringList, analysisExcelDataTime } from "../util/analysisExcel";
    export function get智慧电眼首页() {
        let bolckDataList = getExcelDataBySheetName('智慧电眼数据模板.xlsx', '智慧电眼首页');
        let result = {};
        let ofMoreObjList = [];
        let ofObjList = ["基础数据"];
        let listDataAnalysisInfo = {};
        for (let i = 0; i < bolckDataList.length; i++) {
            let {blockData, blockTitle} = bolckDataList[i];
           
            let changeName = changeDataName(blockTitle);
            if (ofMoreObjList.indexOf(changeName) > -1)  result[changeName] = analysisExcelDataOfMoreObject(blockData, false);
            if (ofObjList.indexOf(changeName) > -1) result[changeName] = analysisExcelDataOfObject(blockData, true, false);
            if (listDataAnalysisInfo[changeName]) result[changeName] = analysisExcelDataOfList(blockData, listDataAnalysisInfo[blockTitle].keyValueObj, false);
        }
        
        return result;
    }
    export function get智慧电眼_城市群协同发展() {
        let bolckDataList = getExcelDataBySheetName('智慧电眼数据模板.xlsx', '智慧电眼_城市群协同发展');
        let result = {};
        let ofMoreObjList = [];
        let ofObjList = ["基础数据","吴江区数据", "范围数据", "青浦区数据", "嘉善县数据", "长三角示范区一体化协同发展指数趋势"];
        let listDataAnalysisInfo = {};
        for (let i = 0; i < bolckDataList.length; i++) {
            let {blockData, blockTitle} = bolckDataList[i];
           
            let changeName = changeDataName(blockTitle);
            if (ofMoreObjList.indexOf(changeName) > -1)  result[changeName] = analysisExcelDataOfMoreObject(blockData, false);
            if (ofObjList.indexOf(changeName) > -1) result[changeName] = analysisExcelDataOfObject(blockData, true, false);
            if (listDataAnalysisInfo[changeName]) result[changeName] = analysisExcelDataOfList(blockData, listDataAnalysisInfo[blockTitle].keyValueObj, false);
        }
        
        return result;
    }
    export function get智慧电眼_规上企业生产运行状况() {
        let bolckDataList = getExcelDataBySheetName('智慧电眼数据模板.xlsx', '智慧电眼_规上企业生产运行状况');
        let result = {};
        let ofMoreObjList = [];
        let ofObjList = ["基础数据", "范围数据","行业生产指数","规上企业行业分布概览","生产指数趋势分析"];
        let listDataAnalysisInfo = {};
        for (let i = 0; i < bolckDataList.length; i++) {
            let {blockData, blockTitle} = bolckDataList[i];
           
            let changeName = changeDataName(blockTitle);
            if (ofMoreObjList.indexOf(changeName) > -1)  result[changeName] = analysisExcelDataOfMoreObject(blockData, false);
            if (ofObjList.indexOf(changeName) > -1) result[changeName] = analysisExcelDataOfObject(blockData, true, false);
            if (listDataAnalysisInfo[changeName]) result[changeName] = analysisExcelDataOfList(blockData, listDataAnalysisInfo[blockTitle].keyValueObj, false);
        }
        
        return result;
    }
    export function get智慧电眼_经济景气度() {
        let bolckDataList = getExcelDataBySheetName('智慧电眼数据模板.xlsx', '智慧电眼_经济景气度');
        let result = {};
        let ofMoreObjList = [];
        let ofObjList = ["基础数据", "范围数据","重点区域景气指数_青浦_","行业景气指数","经济景气指数趋势分析"];
        let listDataAnalysisInfo = {};
        for (let i = 0; i < bolckDataList.length; i++) {
            let {blockData, blockTitle} = bolckDataList[i];
           
            let changeName = changeDataName(blockTitle);
            if (ofMoreObjList.indexOf(changeName) > -1)  result[changeName] = analysisExcelDataOfMoreObject(blockData, false);
            if (ofObjList.indexOf(changeName) > -1) result[changeName] = analysisExcelDataOfObject(blockData, true, false);
            if (listDataAnalysisInfo[changeName]) result[changeName] = analysisExcelDataOfList(blockData, listDataAnalysisInfo[blockTitle].keyValueObj, false);
        }
        
        return result;
    }
    export function get智慧电眼_疑似空壳企业监测() {
        let bolckDataList = getExcelDataBySheetName('智慧电眼数据模板.xlsx', '智慧电眼_疑似空壳企业监测');
        let result = {};
        let ofMoreObjList = [];
        let ofObjList = ["基础数据","范围数据","不同容量疑似空壳企业分布","行业疑似空壳企业分布","疑似空壳企业数变化趋势","疑似空壳企业空壳率变化趋势"];
        let listDataAnalysisInfo = {};
        for (let i = 0; i < bolckDataList.length; i++) {
            let {blockData, blockTitle} = bolckDataList[i];
           
            let changeName = changeDataName(blockTitle);
            if (ofMoreObjList.indexOf(changeName) > -1)  result[changeName] = analysisExcelDataOfMoreObject(blockData, false);
            if (ofObjList.indexOf(changeName) > -1) result[changeName] = analysisExcelDataOfObject(blockData, true, false);
            if (listDataAnalysisInfo[changeName]) result[changeName] = analysisExcelDataOfList(blockData, listDataAnalysisInfo[blockTitle].keyValueObj, false);
        }
        
        return result;
    }
    export function get智慧电眼_企业贷中信用评估() {
        let bolckDataList = getExcelDataBySheetName('智慧电眼数据模板.xlsx', '智慧电眼_企业贷中信用评估');
        let result = {};
        let ofMoreObjList = ["每月企业信用变化趋势","行业信用分布对比"];
        let ofObjList = ["各信用等级企业分布情况", "范围数据","优质信用企业","风险企业"];
        let listDataAnalysisInfo = {};
        for (let i = 0; i < bolckDataList.length; i++) {
            let {blockData, blockTitle} = bolckDataList[i];
           
            let changeName = changeDataName(blockTitle);
            if (ofMoreObjList.indexOf(changeName) > -1)  result[changeName] = analysisExcelDataOfMoreObject(blockData, false);
            if (ofObjList.indexOf(changeName) > -1) result[changeName] = analysisExcelDataOfObject(blockData, true, false);
            if (listDataAnalysisInfo[changeName]) result[changeName] = analysisExcelDataOfList(blockData, listDataAnalysisInfo[blockTitle].keyValueObj, false);
        }
        
        return result;
    }
    export function get智慧电眼_商圈经济活力() {
        let bolckDataList = getExcelDataBySheetName('智慧电眼数据模板.xlsx', '智慧电眼_商圈经济活力');
        let result = {};
        let ofMoreObjList = ["进博会核心区消费类型分析","进博会核心区节假日活力指数分析", "青浦重点商圈经济活力变化趋势", "青浦重点商圈经济活力指数",
        "赵巷区消费类型分析", "赵巷区节假日活力指数分析", "青浦新城消费类型分析", "青浦新城节假日活力指数分析", "朱家角古镇消费类型分析", "朱家角古镇节假日活力指数分析"];
        let ofObjList = ["基础数据","范围数据"];
        let listDataAnalysisInfo = {};
        for (let i = 0; i < bolckDataList.length; i++) {
            let {blockData, blockTitle} = bolckDataList[i];
           
            let changeName = changeDataName(blockTitle);
            if (ofMoreObjList.indexOf(changeName) > -1)  result[changeName] = analysisExcelDataOfMoreObject(blockData, false);
            if (ofObjList.indexOf(changeName) > -1) result[changeName] = analysisExcelDataOfObject(blockData, true, false);
            if (listDataAnalysisInfo[changeName]) result[changeName] = analysisExcelDataOfList(blockData, listDataAnalysisInfo[blockTitle].keyValueObj, false);
        }
        
        return result;
    }
    export function get智慧电眼_重点污染企业生产() {
        let bolckDataList = getExcelDataBySheetName('智慧电眼数据模板.xlsx', '智慧电眼_重点污染企业生产');
        let result = {};
        let ofMoreObjList = ["各污染类型企业生产指数对比","各行业类型污染企业生产指数对比"];
        let ofObjList = ["范围数据","污染企业数据","污染企业生产数据","各镇生产指数","污染类型","污染企业TOP10"];
        let listDataAnalysisInfo = {};
        for (let i = 0; i < bolckDataList.length; i++) {
            let {blockData, blockTitle} = bolckDataList[i];
           
            let changeName = changeDataName(blockTitle);
            if (ofMoreObjList.indexOf(changeName) > -1)  result[changeName] = analysisExcelDataOfMoreObject(blockData, false);
            if (ofObjList.indexOf(changeName) > -1) result[changeName] = analysisExcelDataOfObject(blockData, true, false);
            if (listDataAnalysisInfo[changeName]) result[changeName] = analysisExcelDataOfList(blockData, listDataAnalysisInfo[blockTitle].keyValueObj, false);
        }
        
        return result;
    }
    export function get智慧电眼_行业用电分布() {
        let bolckDataList = getExcelDataBySheetName('智慧电眼数据模板.xlsx', '智慧电眼_行业用电分布');
        let result = {};
        let ofMoreObjList = ["重点行业集中度年度分析_青浦_", "三地各行业用电量"];
        let ofObjList = ["基础数据","行业用电分布","范围数据"];
        let listDataAnalysisInfo = {};
        for (let i = 0; i < bolckDataList.length; i++) {
            let {blockData, blockTitle} = bolckDataList[i];
           
            let changeName = changeDataName(blockTitle);
            if (ofMoreObjList.indexOf(changeName) > -1)  result[changeName] = analysisExcelDataOfMoreObject(blockData, false);
            if (ofObjList.indexOf(changeName) > -1) result[changeName] = analysisExcelDataOfObject(blockData, true, false);
            if (listDataAnalysisInfo[changeName]) result[changeName] = analysisExcelDataOfList(blockData, listDataAnalysisInfo[blockTitle].keyValueObj, false);
        }
        
        return result;
    }
    export function get智慧电眼_住宅空置率() {
        let bolckDataList = getExcelDataBySheetName('智慧电眼数据模板.xlsx', '智慧电眼_住宅空置率');
        let result = {};
        let ofMoreObjList = ["重点区域住房空置率","典型小区住房空置率","重点区域空置户趋势","典型小区空置户趋势"];
        let ofObjList = ["空置户数据","住房空置率数据","空置用户电量数据","青浦区住房空置率趋势","范围数据"];
        let listDataAnalysisInfo = {};
        for (let i = 0; i < bolckDataList.length; i++) {
            let {blockData, blockTitle} = bolckDataList[i];
           
            let changeName = changeDataName(blockTitle);
            if (ofMoreObjList.indexOf(changeName) > -1)  result[changeName] = analysisExcelDataOfMoreObject(blockData, false);
            if (ofObjList.indexOf(changeName) > -1) result[changeName] = analysisExcelDataOfObject(blockData, true, false);
            if (listDataAnalysisInfo[changeName]) result[changeName] = analysisExcelDataOfList(blockData, listDataAnalysisInfo[blockTitle].keyValueObj, false);
        }
        
        return result;
    }

    //--{"工程进度":{"titleList":["工程名称","开始时间","预计完成时间","工程进度"],"keyValueObj":{"工程名称":"name","开始时间":"startTime","预计完成时间":"endTime","工程进度":"rate"}},"调度日志":{"titleList":["状态","序号","时间","申请人","所属区域","管理单位","业务分类"],"keyValueObj":{"状态":"state","序号":"number","时间":"time","申请人":"name","所属区域":"area","管理单位":"department","业务分类":"type"}}};
    export function get绿色电力_充电设施发展监控() {
        let bolckDataList = getExcelDataBySheetName('绿色电力数据模板.xlsx', '绿色电力_充电设施发展监控');
        let result = {};
        let ofMoreObjList = ["同比趋势分析","环比趋势分析","各指数成分趋势分析","同比趋势分析","环比趋势分析"];
        let ofObjList = ["每月服务车次","当期绿电指数","绿电指数折线图","充电设施发展监控","服务车次","设施安全服务","设施安全服务充电桩使用率"];
        let listDataAnalysisInfo = {
            "绿电指数与经济指数相关分析_2017_2020_":{"titleList":["指数","金额(亿元)"], "keyValueObj":{"指数":'x',"金额(亿元)":'y'} },
            "上海市空气质量AQI优良率":{"titleList":["绿电指数","优良率"], "keyValueObj":{"绿电指数":'x',"优良率":'y'} },
            "青浦区PM2.5月均浓度":{"titleList":["绿电指数","PM2.5浓度"], "keyValueObj":{"绿电指数":'x',"PM2.5浓度":'y'} },
            "绿电指数与经济指数相关分析均值":{"titleList":["指数","金额(亿元)"], "keyValueObj":{"指数":'x',"金额(亿元)":'y'} },
            "上海市空气质量AQI优良率均值":{"titleList":["绿电指数","优良率"], "keyValueObj":{"绿电指数":'x',"优良率":'y'} },
            "青浦区PM2.5月均浓度均值":{"titleList":["绿电指数","PM2.5浓度"], "keyValueObj":{"绿电指数":'x',"PM2.5浓度":'y'} }
        };
        for (let i = 0; i < bolckDataList.length; i++) {
            let {blockData, blockTitle} = bolckDataList[i];
           
            let changeName = changeDataName(blockTitle);
            if (ofMoreObjList.indexOf(changeName) > -1)  result[changeName] = analysisExcelDataOfMoreObject(blockData, false);
            if (ofObjList.indexOf(changeName) > -1) result[changeName] = analysisExcelDataOfObject(blockData, true, false);
            if (listDataAnalysisInfo[changeName]) {
                if ("青浦区PM2.5月均浓度" == blockTitle) result["青浦区PM2_5月均浓度"] = analysisExcelDataOfList(blockData, listDataAnalysisInfo[changeName].keyValueObj, false);
                if ("青浦区PM2.5月均浓度均值" == blockTitle) result["青浦区PM2_5月均浓度均值"] = analysisExcelDataOfList(blockData, listDataAnalysisInfo[changeName].keyValueObj, false);
                else result[changeName] = analysisExcelDataOfList(blockData, listDataAnalysisInfo[changeName].keyValueObj, false);
            }
        }
        
        return result;
    }
    export function get绿色电力_清洁能源光伏接入情况() {
        let bolckDataList = getExcelDataBySheetName('绿色电力数据模板.xlsx', '绿色电力_清洁能源光伏接入情况');
        let result = {};
        let ofMoreObjList = ["近12个月电量分析",  "各指数成分趋势分析"];
        let ofObjList = ["当期绿电指数","客户总量","各类污染物减排占比","清洁能源光伏接入情况","分布式光伏客户接入变化趋势","绿电指数折线图"];
        let listDataAnalysisInfo = {
            "当期指数分四象限分析":{"titleList":["指数","线损率", "名称"], "keyValueObj":{"指数":'x',"线损率":'y', "名称":"name"} },
            "当期指数分四象限分析指标":{"titleList":["指数","线损率"], "keyValueObj":{"指数":'x',"线损率":'y'} },
        };

        for (let i = 0; i < bolckDataList.length; i++) {
            let {blockData, blockTitle} = bolckDataList[i];
           
            let changeName = changeDataName(blockTitle);
            if (ofMoreObjList.indexOf(changeName) > -1)  result[changeName] = analysisExcelDataOfMoreObject(blockData, false);
            if (ofObjList.indexOf(changeName) > -1) result[changeName] = analysisExcelDataOfObject(blockData, true, false);
            if (listDataAnalysisInfo[changeName]) result[changeName] = analysisExcelDataOfList(blockData, listDataAnalysisInfo[blockTitle].keyValueObj, false);
        }
        
        return result;
    }
    export function get平台基础能力() {
        let bolckDataList = getExcelDataBySheetName('其他数据模板.xlsx', '智慧数据赋能');
        let result = {};
        let ofMoreObjList = [];
        let ofObjList = ["虚拟机资源管理","IT资源管理"];
        let ofStringList = ["数据服务能力", "数据采集", "数据业务能力图片"];
        let ofTimeObj=["CPU使用情况"];
        let listDataAnalysisInfo = {};
        for (let i = 0; i < bolckDataList.length; i++) {
            let {blockData, blockTitle} = bolckDataList[i];
           
            let changeName = changeDataName(blockTitle);
            if (ofMoreObjList.indexOf(changeName) > -1)  result[changeName] = analysisExcelDataOfMoreObject(blockData, false);
            if (ofObjList.indexOf(changeName) > -1) result[changeName] = analysisExcelDataOfObject(blockData, true, false);
            if (listDataAnalysisInfo[changeName]) result[changeName] = analysisExcelDataOfList(blockData, listDataAnalysisInfo[blockTitle].keyValueObj, false);
            if (ofStringList.indexOf(changeName) > -1) result[changeName] = analysisExcelDataOfStringList(blockData);
            if (ofTimeObj.indexOf(changeName) > -1) result[changeName] = analysisExcelDataTime(blockData, true, false);

        }

        return result;
    }
    export function get示范区总体概况() {
        let bolckDataList = getExcelDataBySheetName('其他数据模板.xlsx', '示范区总体概况');
        let result = {};
        let ofMoreObjList = [];
        let ofObjList = ["常住人口_万人_","地区生产总值_亿元_","示范区面积_平方公里_","基础数据", "先行启动区"];
        let listDataAnalysisInfo = {"电力先行成果":{"titleList":["时间","内容"],"keyValueObj":{"时间":"time","内容":"info"}},"一体化大事件":{"titleList":["时间","内容"],"keyValueObj":{"时间":"time","内容":"info"}},"变电站数量":{"titleList":["电站标准","青浦区","吴江区","嘉善县"],"keyValueObj":{"电站标准":"standard","青浦区":"qpq","吴江区":"wjq","嘉善县":"jsq"}}};
        for (let i = 0; i < bolckDataList.length; i++) {
            let {blockData, blockTitle} = bolckDataList[i];
           
            let changeName = changeDataName(blockTitle);
            if (ofMoreObjList.indexOf(changeName) > -1)  result[changeName] = analysisExcelDataOfMoreObject(blockData, false);
            if (ofObjList.indexOf(changeName) > -1) result[changeName] = analysisExcelDataOfObject(blockData, true, false);
            if (listDataAnalysisInfo[changeName]) result[changeName] = analysisExcelDataOfList(blockData, listDataAnalysisInfo[blockTitle].keyValueObj, false);
        }
        
        return result;
    }
    export function get区域融合() {
        let bolckDataList = getExcelDataBySheetName('其他数据模板.xlsx', '区域融合');
        let result = {};
        let ofMoreObjList = ["各区受理量对比","各区办结量对比","电网作业风险事件"];
        let ofObjList = [
            "地图链接", "营商业务互动性", "一体化电网运行管理","一体化新型电力系统","企业客户_一码通识_",
            "用电状态可_分色识别_","针对性供电服务_随码跟进_","营商业务便利性","供电可靠性","营商业务及时性", "嘉善县", "吴江区", "青浦区",
            "供电可靠性_青浦区","营商业务便利性_青浦区","营商业务及时性_青浦区", "营商业务互动性_青浦区",
            "供电可靠性_嘉善县", "营商业务便利性_嘉善县", "营商业务及时性_嘉善县", "营商业务互动性_嘉善县",
            "供电可靠性_吴江区", "营商业务便利性_吴江区", "营商业务及时性_吴江区", "营商业务互动性_吴江区"
        ];
        let listDataAnalysisInfo = {
            "工程进度":{
                "titleList":["工程名称","开始时间","预计完成时间","工程进度"],
                "keyValueObj":{"工程名称":"name","开始时间":"startTime","预计完成时间":"endTime","工程进度":"rate"}},
            "调度日志":{
                "titleList":["状态","序号","时间","申请人","所属区域","管理单位","业务分类"],
                "keyValueObj":{"状态":"state","序号":"number","时间":"time","申请人":"name","所属区域":"area","管理单位":"department","业务分类":"type"}
            },
            "值班管理":{
                "titleList":["名称", "是否到岗"],
                "keyValueObj":{"名称":"name", "是否到岗":"state"}
            },
            "调度日志_检修计划":{
                "titleList":["序号","区域","工作内容","日期"],
                "keyValueObj":{"序号":"number","区域":"area","工作内容":"info","日期":"time"}
            },
            "调度日志_故障抢修":{
                "titleList":["序号","区域","工作内容","日期"],
                "keyValueObj":{"序号":"number","区域":"area","工作内容":"info","日期":"time"}
            },
            "调度日志_停电停役":{
                "titleList":["序号","区域","工作内容","日期"],
                "keyValueObj":{"序号":"number","区域":"area","工作内容":"info","日期":"time"}
            },
            "调度日志_设备缺陷":{
                "titleList":["序号","区域","工作内容","日期"],
                "keyValueObj":{"序号":"number","区域":"area","工作内容":"info","日期":"time"}
            },
            "调度日志_事故异常":{
                "titleList":["序号","区域","工作内容","日期"],
                "keyValueObj":{"序号":"number","区域":"area","工作内容":"info","日期":"time"}
            },
            "线路负荷率":{
                "titleList":["数据名称","最大值","最小值"],
                "keyValueObj":{"数据名称":"name","最大值":"max","最小值":"min"}
            },
        };
        for (let i = 0; i < bolckDataList.length; i++) {
            let {blockData, blockTitle} = bolckDataList[i];
           
            let changeName = changeDataName(blockTitle);
            if (ofMoreObjList.indexOf(changeName) > -1)  {
                result[changeName] = analysisExcelDataOfMoreObject(blockData, false);
            }
            if (ofObjList.indexOf(changeName) > -1) {
                result[changeName] = analysisExcelDataOfObject(blockData, true, false);
            }
            if (listDataAnalysisInfo[changeName]) {
                result[changeName] = analysisExcelDataOfList(blockData, listDataAnalysisInfo[changeName].keyValueObj, false);
            }
        }
        
        return result;
    }
    export function get综合能源() {
        let bolckDataList = getExcelDataBySheetName('其他数据模板.xlsx', '综合能源');
        let result = {};
        let ofMoreObjList = ["用户类型_青浦区_","行业分类用户_青浦区_"];
        let ofObjList = ["潜力用户概览","综合能源智能匹配","项目覆盖范围","系统效果","储能用户月分析_青浦区_","储能用户季度分析_青浦区_","储能用户年分析_青浦区_"];
        let listDataAnalysisInfo = {"服务方案热度排名":{"titleList":["排名","方案名称","热度"],"keyValueObj":{"排名":"rank","方案名称":"name","热度":"info"}},"服务方案收益排名":{"titleList":["排名","方案名称","收益"],"keyValueObj":{"排名":"rank","方案名称":"name","收益":"info"}}};
        let ofStringList = ["青浦区综合能效服务项目案例", "综合能源智能匹配文本", "系统配置"];
        for (let i = 0; i < bolckDataList.length; i++) {
            let {blockData, blockTitle} = bolckDataList[i];
           
            let changeName = changeDataName(blockTitle);
            if (ofMoreObjList.indexOf(changeName) > -1)  result[changeName] = analysisExcelDataOfMoreObject(blockData, false);
            if (ofObjList.indexOf(changeName) > -1) result[changeName] = analysisExcelDataOfObject(blockData, true, false);
            if (listDataAnalysisInfo[changeName]) result[changeName] = analysisExcelDataOfList(blockData, listDataAnalysisInfo[blockTitle].keyValueObj, false);
            if (ofStringList.indexOf(changeName) > -1) result[changeName] = analysisExcelDataOfStringList(blockData);
        }
        
        return result;
    }