
    import { getChartData, getKeyValue, getListData, getSingleYAndMoreData, getMoreYChartData, objKeyReplace, getStringMoreData }from "../util/tools";
    import { get示范区总体概况 } from "../data/analysisExcelData";
    
    export function getData(req, res) {
        let ret:any = {};

        let excelData:any = get示范区总体概况();
    
        let 常住人口_万人_DataAndUnit = objKeyReplace(excelData.常住人口_万人_);
        ret["api1"] =  getKeyValue("常住人口（万人）", 常住人口_万人_DataAndUnit.dataMap, 常住人口_万人_DataAndUnit.unitMap, true, false );
    
        let 地区生产总值_亿元_DataAndUnit = objKeyReplace(excelData.地区生产总值_亿元_);
        ret["api2"] =  getKeyValue("地区生产总值（亿元）", 地区生产总值_亿元_DataAndUnit.dataMap, 地区生产总值_亿元_DataAndUnit.unitMap, true, false );
    
        let 示范区面积_平方公里_DataAndUnit = objKeyReplace(excelData.示范区面积_平方公里_);
        ret["api3"] =  getKeyValue("示范区面积（平方公里）", 示范区面积_平方公里_DataAndUnit.dataMap, 示范区面积_平方公里_DataAndUnit.unitMap, true, false );
    
        let 基础数据DataAndUnit = objKeyReplace(excelData.基础数据);
        ret["api4"] =  getKeyValue("基础数据", 基础数据DataAndUnit.dataMap, 基础数据DataAndUnit.unitMap, false, false );
    
        ret["api5"] = getListData("电力先行成果",excelData.电力先行成果,["时间","内容"],{"时间":"time","内容":"info"});
    
        ret["api6"] = getListData("一体化大事件",excelData.一体化大事件,["时间","内容"],{"时间":"time","内容":"info"});
    
        ret["api7"] = getListData("变电站数量",excelData.变电站数量,["电站标准","青浦区","吴江区","嘉善县"],{"电站标准":"standard","青浦区":"qpq","吴江区":"wjq","嘉善县":"jsq"});

        const 先行启动区数据 = [];
        for (let key in excelData.先行启动区) {
            先行启动区数据.push(excelData.先行启动区[key]);
        }
        ret["api8"] = getStringMoreData("先行启动区", 先行启动区数据);
    
        res.send(ret);
    }
    